/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Map;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

class S3URI {
    private static final String SCHEME_DELIM = "://";
    private static final String PATH_DELIM = "/";
    private static final String QUERY_DELIM = "\\?";
    private static final String FRAGMENT_DELIM = "#";
    private final String location;
    private final String scheme;
    private final String bucket;
    private final String key;

    S3URI(String location) {
        this(location, (Map<String, String>)ImmutableMap.of());
    }

    S3URI(String location, Map<String, String> bucketToAccessPointMapping) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null.");
        this.location = location;
        String[] schemeSplit = location.split(SCHEME_DELIM, -1);
        ValidationException.check((schemeSplit.length == 2 ? 1 : 0) != 0, (String)"Invalid S3 URI, cannot determine scheme: %s", (Object[])new Object[]{location});
        this.scheme = schemeSplit[0];
        String[] authoritySplit = schemeSplit[1].split(PATH_DELIM, 2);
        this.bucket = bucketToAccessPointMapping == null ? authoritySplit[0] : bucketToAccessPointMapping.getOrDefault(authoritySplit[0], authoritySplit[0]);
        String path = authoritySplit.length > 1 ? authoritySplit[1] : "";
        path = path.split(QUERY_DELIM, -1)[0];
        this.key = path = path.split(FRAGMENT_DELIM, -1)[0];
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String location() {
        return this.location;
    }

    public String scheme() {
        return this.scheme;
    }

    public String toString() {
        return this.location;
    }
}

