/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.metrics.MetricsReporter;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TableScanContext", generator="Immutables")
@Immutable
final class ImmutableTableScanContext
extends TableScanContext {
    @Nullable
    private final Long snapshotId;
    private final Expression rowFilter;
    private final boolean ignoreResiduals;
    private final boolean caseSensitive;
    private final boolean returnColumnStats;
    @Nullable
    private final Set<Integer> columnsToKeepStats;
    @Nullable
    private final Collection<String> selectedColumns;
    @Nullable
    private final Schema projectedSchema;
    private final Map<String, String> options;
    @Nullable
    private final Long fromSnapshotId;
    private final boolean fromSnapshotInclusive;
    @Nullable
    private final Long toSnapshotId;
    private final ExecutorService planExecutor;
    private final transient boolean planWithCustomizedExecutor;
    private final MetricsReporter metricsReporter;
    @Nullable
    private final String branch;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTableScanContext(Builder builder) {
        this.snapshotId = builder.snapshotId;
        this.columnsToKeepStats = builder.columnsToKeepStats == null ? null : ImmutableTableScanContext.createUnmodifiableSet(builder.columnsToKeepStats);
        this.selectedColumns = builder.selectedColumns;
        this.projectedSchema = builder.projectedSchema;
        this.fromSnapshotId = builder.fromSnapshotId;
        this.toSnapshotId = builder.toSnapshotId;
        this.branch = builder.branch;
        if (builder.rowFilter != null) {
            this.initShim.rowFilter(builder.rowFilter);
        }
        if (builder.ignoreResidualsIsSet()) {
            this.initShim.ignoreResiduals(builder.ignoreResiduals);
        }
        if (builder.caseSensitiveIsSet()) {
            this.initShim.caseSensitive(builder.caseSensitive);
        }
        if (builder.returnColumnStatsIsSet()) {
            this.initShim.returnColumnStats(builder.returnColumnStats);
        }
        if (builder.optionsIsSet()) {
            this.initShim.options(ImmutableTableScanContext.createUnmodifiableMap(false, false, builder.options));
        }
        if (builder.fromSnapshotInclusiveIsSet()) {
            this.initShim.fromSnapshotInclusive(builder.fromSnapshotInclusive);
        }
        if (builder.planExecutor != null) {
            this.initShim.planExecutor(builder.planExecutor);
        }
        if (builder.metricsReporter != null) {
            this.initShim.metricsReporter(builder.metricsReporter);
        }
        this.rowFilter = this.initShim.rowFilter();
        this.ignoreResiduals = this.initShim.ignoreResiduals();
        this.caseSensitive = this.initShim.caseSensitive();
        this.returnColumnStats = this.initShim.returnColumnStats();
        this.options = this.initShim.options();
        this.fromSnapshotInclusive = this.initShim.fromSnapshotInclusive();
        this.planExecutor = this.initShim.planExecutor();
        this.planWithCustomizedExecutor = this.initShim.planWithCustomizedExecutor();
        this.metricsReporter = this.initShim.metricsReporter();
        this.initShim = null;
    }

    private ImmutableTableScanContext(@Nullable Long snapshotId, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean returnColumnStats, @Nullable Set<Integer> columnsToKeepStats, @Nullable Collection<String> selectedColumns, @Nullable Schema projectedSchema, Map<String, String> options, @Nullable Long fromSnapshotId, boolean fromSnapshotInclusive, @Nullable Long toSnapshotId, ExecutorService planExecutor, MetricsReporter metricsReporter, @Nullable String branch) {
        this.snapshotId = snapshotId;
        this.initShim.rowFilter(rowFilter);
        this.initShim.ignoreResiduals(ignoreResiduals);
        this.initShim.caseSensitive(caseSensitive);
        this.initShim.returnColumnStats(returnColumnStats);
        this.columnsToKeepStats = columnsToKeepStats;
        this.selectedColumns = selectedColumns;
        this.projectedSchema = projectedSchema;
        this.initShim.options(options);
        this.fromSnapshotId = fromSnapshotId;
        this.initShim.fromSnapshotInclusive(fromSnapshotInclusive);
        this.toSnapshotId = toSnapshotId;
        this.initShim.planExecutor(planExecutor);
        this.initShim.metricsReporter(metricsReporter);
        this.branch = branch;
        this.rowFilter = this.initShim.rowFilter();
        this.ignoreResiduals = this.initShim.ignoreResiduals();
        this.caseSensitive = this.initShim.caseSensitive();
        this.returnColumnStats = this.initShim.returnColumnStats();
        this.options = this.initShim.options();
        this.fromSnapshotInclusive = this.initShim.fromSnapshotInclusive();
        this.planExecutor = this.initShim.planExecutor();
        this.planWithCustomizedExecutor = this.initShim.planWithCustomizedExecutor();
        this.metricsReporter = this.initShim.metricsReporter();
        this.initShim = null;
    }

    @Override
    @Nullable
    public Long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Expression rowFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rowFilter() : this.rowFilter;
    }

    @Override
    public boolean ignoreResiduals() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ignoreResiduals() : this.ignoreResiduals;
    }

    @Override
    public boolean caseSensitive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.caseSensitive() : this.caseSensitive;
    }

    @Override
    public boolean returnColumnStats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.returnColumnStats() : this.returnColumnStats;
    }

    @Override
    @Nullable
    public Set<Integer> columnsToKeepStats() {
        return this.columnsToKeepStats;
    }

    @Override
    @Nullable
    public Collection<String> selectedColumns() {
        return this.selectedColumns;
    }

    @Override
    @Nullable
    public Schema projectedSchema() {
        return this.projectedSchema;
    }

    @Override
    public Map<String, String> options() {
        InitShim shim = this.initShim;
        return shim != null ? shim.options() : this.options;
    }

    @Override
    @Nullable
    public Long fromSnapshotId() {
        return this.fromSnapshotId;
    }

    @Override
    public boolean fromSnapshotInclusive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fromSnapshotInclusive() : this.fromSnapshotInclusive;
    }

    @Override
    @Nullable
    public Long toSnapshotId() {
        return this.toSnapshotId;
    }

    @Override
    public ExecutorService planExecutor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.planExecutor() : this.planExecutor;
    }

    @Override
    boolean planWithCustomizedExecutor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.planWithCustomizedExecutor() : this.planWithCustomizedExecutor;
    }

    @Override
    public MetricsReporter metricsReporter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metricsReporter() : this.metricsReporter;
    }

    @Override
    @Nullable
    public String branch() {
        return this.branch;
    }

    public final ImmutableTableScanContext withSnapshotId(@Nullable Long value) {
        if (Objects.equals(this.snapshotId, value)) {
            return this;
        }
        return new ImmutableTableScanContext(value, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withRowFilter(Expression value) {
        if (this.rowFilter == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "rowFilter");
        return new ImmutableTableScanContext(this.snapshotId, newValue, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withIgnoreResiduals(boolean value) {
        if (this.ignoreResiduals == value) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, value, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withCaseSensitive(boolean value) {
        if (this.caseSensitive == value) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, value, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withReturnColumnStats(boolean value) {
        if (this.returnColumnStats == value) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, value, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withColumnsToKeepStats(int ... elements) {
        if (elements == null) {
            return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, null, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
        }
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        Set<Integer> newValue = ImmutableTableScanContext.createUnmodifiableSet(wrappedList);
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, newValue, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withColumnsToKeepStats(@Nullable Iterable<Integer> elements) {
        if (this.columnsToKeepStats == elements) {
            return this;
        }
        Set<Integer> newValue = elements == null ? null : ImmutableTableScanContext.createUnmodifiableSet(ImmutableTableScanContext.createSafeList(elements, true, false));
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, newValue, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withSelectedColumns(@Nullable Collection<String> value) {
        if (this.selectedColumns == value) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, value, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withProjectedSchema(@Nullable Schema value) {
        if (this.projectedSchema == value) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, value, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableTableScanContext.createUnmodifiableMap(true, false, entries);
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, newValue, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withFromSnapshotId(@Nullable Long value) {
        if (Objects.equals(this.fromSnapshotId, value)) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, value, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withFromSnapshotInclusive(boolean value) {
        if (this.fromSnapshotInclusive == value) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, value, this.toSnapshotId, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withToSnapshotId(@Nullable Long value) {
        if (Objects.equals(this.toSnapshotId, value)) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, value, this.planExecutor, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withPlanExecutor(ExecutorService value) {
        if (this.planExecutor == value) {
            return this;
        }
        ExecutorService newValue = Objects.requireNonNull(value, "planExecutor");
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, newValue, this.metricsReporter, this.branch);
    }

    public final ImmutableTableScanContext withMetricsReporter(MetricsReporter value) {
        if (this.metricsReporter == value) {
            return this;
        }
        MetricsReporter newValue = Objects.requireNonNull(value, "metricsReporter");
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, newValue, this.branch);
    }

    public final ImmutableTableScanContext withBranch(@Nullable String value) {
        if (Objects.equals(this.branch, value)) {
            return this;
        }
        return new ImmutableTableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.returnColumnStats, this.columnsToKeepStats, this.selectedColumns, this.projectedSchema, this.options, this.fromSnapshotId, this.fromSnapshotInclusive, this.toSnapshotId, this.planExecutor, this.metricsReporter, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTableScanContext && this.equalTo(0, (ImmutableTableScanContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableTableScanContext another) {
        return Objects.equals(this.snapshotId, another.snapshotId) && this.rowFilter.equals(another.rowFilter) && this.ignoreResiduals == another.ignoreResiduals && this.caseSensitive == another.caseSensitive && this.returnColumnStats == another.returnColumnStats && Objects.equals(this.columnsToKeepStats, another.columnsToKeepStats) && Objects.equals(this.selectedColumns, another.selectedColumns) && Objects.equals(this.projectedSchema, another.projectedSchema) && this.options.equals(another.options) && Objects.equals(this.fromSnapshotId, another.fromSnapshotId) && this.fromSnapshotInclusive == another.fromSnapshotInclusive && Objects.equals(this.toSnapshotId, another.toSnapshotId) && this.planExecutor.equals(another.planExecutor) && this.planWithCustomizedExecutor == another.planWithCustomizedExecutor && this.metricsReporter.equals(another.metricsReporter) && Objects.equals(this.branch, another.branch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.snapshotId);
        h += (h << 5) + this.rowFilter.hashCode();
        h += (h << 5) + Boolean.hashCode(this.ignoreResiduals);
        h += (h << 5) + Boolean.hashCode(this.caseSensitive);
        h += (h << 5) + Boolean.hashCode(this.returnColumnStats);
        h += (h << 5) + Objects.hashCode(this.columnsToKeepStats);
        h += (h << 5) + Objects.hashCode(this.selectedColumns);
        h += (h << 5) + Objects.hashCode(this.projectedSchema);
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + Objects.hashCode(this.fromSnapshotId);
        h += (h << 5) + Boolean.hashCode(this.fromSnapshotInclusive);
        h += (h << 5) + Objects.hashCode(this.toSnapshotId);
        h += (h << 5) + this.planExecutor.hashCode();
        h += (h << 5) + Boolean.hashCode(this.planWithCustomizedExecutor);
        h += (h << 5) + this.metricsReporter.hashCode();
        h += (h << 5) + Objects.hashCode(this.branch);
        return h;
    }

    public String toString() {
        return "TableScanContext{snapshotId=" + this.snapshotId + ", rowFilter=" + this.rowFilter + ", ignoreResiduals=" + this.ignoreResiduals + ", caseSensitive=" + this.caseSensitive + ", returnColumnStats=" + this.returnColumnStats + ", columnsToKeepStats=" + this.columnsToKeepStats + ", selectedColumns=" + this.selectedColumns + ", projectedSchema=" + this.projectedSchema + ", options=" + this.options + ", fromSnapshotId=" + this.fromSnapshotId + ", fromSnapshotInclusive=" + this.fromSnapshotInclusive + ", toSnapshotId=" + this.toSnapshotId + ", planExecutor=" + this.planExecutor + ", planWithCustomizedExecutor=" + this.planWithCustomizedExecutor + ", metricsReporter=" + this.metricsReporter + ", branch=" + this.branch + "}";
    }

    public static ImmutableTableScanContext copyOf(TableScanContext instance) {
        if (instance instanceof ImmutableTableScanContext) {
            return (ImmutableTableScanContext)instance;
        }
        return ImmutableTableScanContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="TableScanContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_IGNORE_RESIDUALS = 1L;
        private static final long OPT_BIT_CASE_SENSITIVE = 2L;
        private static final long OPT_BIT_RETURN_COLUMN_STATS = 4L;
        private static final long OPT_BIT_OPTIONS = 8L;
        private static final long OPT_BIT_FROM_SNAPSHOT_INCLUSIVE = 16L;
        private long optBits;
        @Nullable
        private Long snapshotId;
        @Nullable
        private Expression rowFilter;
        private boolean ignoreResiduals;
        private boolean caseSensitive;
        private boolean returnColumnStats;
        private List<Integer> columnsToKeepStats = null;
        @Nullable
        private Collection<String> selectedColumns;
        @Nullable
        private Schema projectedSchema;
        private Map<String, String> options = new LinkedHashMap<String, String>();
        @Nullable
        private Long fromSnapshotId;
        private boolean fromSnapshotInclusive;
        @Nullable
        private Long toSnapshotId;
        @Nullable
        private ExecutorService planExecutor;
        @Nullable
        private MetricsReporter metricsReporter;
        @Nullable
        private String branch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TableScanContext instance) {
            Schema projectedSchemaValue;
            Collection<String> selectedColumnsValue;
            Objects.requireNonNull(instance, "instance");
            Long snapshotIdValue = instance.snapshotId();
            if (snapshotIdValue != null) {
                this.snapshotId(snapshotIdValue);
            }
            this.rowFilter(instance.rowFilter());
            this.ignoreResiduals(instance.ignoreResiduals());
            this.caseSensitive(instance.caseSensitive());
            this.returnColumnStats(instance.returnColumnStats());
            Set<Integer> columnsToKeepStatsValue = instance.columnsToKeepStats();
            if (columnsToKeepStatsValue != null) {
                this.addAllColumnsToKeepStats(columnsToKeepStatsValue);
            }
            if ((selectedColumnsValue = instance.selectedColumns()) != null) {
                this.selectedColumns(selectedColumnsValue);
            }
            if ((projectedSchemaValue = instance.projectedSchema()) != null) {
                this.projectedSchema(projectedSchemaValue);
            }
            this.putAllOptions(instance.options());
            Long fromSnapshotIdValue = instance.fromSnapshotId();
            if (fromSnapshotIdValue != null) {
                this.fromSnapshotId(fromSnapshotIdValue);
            }
            this.fromSnapshotInclusive(instance.fromSnapshotInclusive());
            Long toSnapshotIdValue = instance.toSnapshotId();
            if (toSnapshotIdValue != null) {
                this.toSnapshotId(toSnapshotIdValue);
            }
            this.planExecutor(instance.planExecutor());
            this.metricsReporter(instance.metricsReporter());
            String branchValue = instance.branch();
            if (branchValue != null) {
                this.branch(branchValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(@Nullable Long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowFilter(Expression rowFilter) {
            this.rowFilter = Objects.requireNonNull(rowFilter, "rowFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ignoreResiduals(boolean ignoreResiduals) {
            this.ignoreResiduals = ignoreResiduals;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returnColumnStats(boolean returnColumnStats) {
            this.returnColumnStats = returnColumnStats;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumnsToKeepStats(int element) {
            if (this.columnsToKeepStats == null) {
                this.columnsToKeepStats = new ArrayList<Integer>();
            }
            this.columnsToKeepStats.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumnsToKeepStats(int ... elements) {
            if (this.columnsToKeepStats == null) {
                this.columnsToKeepStats = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.columnsToKeepStats.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columnsToKeepStats(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.columnsToKeepStats = null;
                return this;
            }
            this.columnsToKeepStats = new ArrayList<Integer>();
            return this.addAllColumnsToKeepStats(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllColumnsToKeepStats(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "columnsToKeepStats element");
            if (this.columnsToKeepStats == null) {
                this.columnsToKeepStats = new ArrayList<Integer>();
            }
            for (Integer element : elements) {
                this.columnsToKeepStats.add(Objects.requireNonNull(element, "columnsToKeepStats element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder selectedColumns(@Nullable Collection<String> selectedColumns) {
            this.selectedColumns = selectedColumns;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectedSchema(@Nullable Schema projectedSchema) {
            this.projectedSchema = projectedSchema;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "options value for key: " + k : null));
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options.clear();
            this.optBits |= 8L;
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "options value for key: " + k : null));
            }
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromSnapshotId(@Nullable Long fromSnapshotId) {
            this.fromSnapshotId = fromSnapshotId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromSnapshotInclusive(boolean fromSnapshotInclusive) {
            this.fromSnapshotInclusive = fromSnapshotInclusive;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toSnapshotId(@Nullable Long toSnapshotId) {
            this.toSnapshotId = toSnapshotId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder planExecutor(ExecutorService planExecutor) {
            this.planExecutor = Objects.requireNonNull(planExecutor, "planExecutor");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsReporter(MetricsReporter metricsReporter) {
            this.metricsReporter = Objects.requireNonNull(metricsReporter, "metricsReporter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder branch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public ImmutableTableScanContext build() {
            return new ImmutableTableScanContext(this);
        }

        private boolean ignoreResidualsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean caseSensitiveIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean returnColumnStatsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean optionsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean fromSnapshotInclusiveIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    @Generated(from="TableScanContext", generator="Immutables")
    private final class InitShim {
        private byte rowFilterBuildStage = 0;
        private Expression rowFilter;
        private byte ignoreResidualsBuildStage = 0;
        private boolean ignoreResiduals;
        private byte caseSensitiveBuildStage = 0;
        private boolean caseSensitive;
        private byte returnColumnStatsBuildStage = 0;
        private boolean returnColumnStats;
        private byte optionsBuildStage = 0;
        private Map<String, String> options;
        private byte fromSnapshotInclusiveBuildStage = 0;
        private boolean fromSnapshotInclusive;
        private byte planExecutorBuildStage = 0;
        private ExecutorService planExecutor;
        private byte planWithCustomizedExecutorBuildStage = 0;
        private boolean planWithCustomizedExecutor;
        private byte metricsReporterBuildStage = 0;
        private MetricsReporter metricsReporter;

        private InitShim() {
        }

        Expression rowFilter() {
            if (this.rowFilterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rowFilterBuildStage == 0) {
                this.rowFilterBuildStage = (byte)-1;
                this.rowFilter = Objects.requireNonNull(ImmutableTableScanContext.super.rowFilter(), "rowFilter");
                this.rowFilterBuildStage = 1;
            }
            return this.rowFilter;
        }

        void rowFilter(Expression rowFilter) {
            this.rowFilter = rowFilter;
            this.rowFilterBuildStage = 1;
        }

        boolean ignoreResiduals() {
            if (this.ignoreResidualsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ignoreResidualsBuildStage == 0) {
                this.ignoreResidualsBuildStage = (byte)-1;
                this.ignoreResiduals = ImmutableTableScanContext.super.ignoreResiduals();
                this.ignoreResidualsBuildStage = 1;
            }
            return this.ignoreResiduals;
        }

        void ignoreResiduals(boolean ignoreResiduals) {
            this.ignoreResiduals = ignoreResiduals;
            this.ignoreResidualsBuildStage = 1;
        }

        boolean caseSensitive() {
            if (this.caseSensitiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.caseSensitiveBuildStage == 0) {
                this.caseSensitiveBuildStage = (byte)-1;
                this.caseSensitive = ImmutableTableScanContext.super.caseSensitive();
                this.caseSensitiveBuildStage = 1;
            }
            return this.caseSensitive;
        }

        void caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.caseSensitiveBuildStage = 1;
        }

        boolean returnColumnStats() {
            if (this.returnColumnStatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.returnColumnStatsBuildStage == 0) {
                this.returnColumnStatsBuildStage = (byte)-1;
                this.returnColumnStats = ImmutableTableScanContext.super.returnColumnStats();
                this.returnColumnStatsBuildStage = 1;
            }
            return this.returnColumnStats;
        }

        void returnColumnStats(boolean returnColumnStats) {
            this.returnColumnStats = returnColumnStats;
            this.returnColumnStatsBuildStage = 1;
        }

        Map<String, String> options() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableTableScanContext.createUnmodifiableMap(true, false, ImmutableTableScanContext.super.options());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(Map<String, String> options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        boolean fromSnapshotInclusive() {
            if (this.fromSnapshotInclusiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fromSnapshotInclusiveBuildStage == 0) {
                this.fromSnapshotInclusiveBuildStage = (byte)-1;
                this.fromSnapshotInclusive = ImmutableTableScanContext.super.fromSnapshotInclusive();
                this.fromSnapshotInclusiveBuildStage = 1;
            }
            return this.fromSnapshotInclusive;
        }

        void fromSnapshotInclusive(boolean fromSnapshotInclusive) {
            this.fromSnapshotInclusive = fromSnapshotInclusive;
            this.fromSnapshotInclusiveBuildStage = 1;
        }

        ExecutorService planExecutor() {
            if (this.planExecutorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.planExecutorBuildStage == 0) {
                this.planExecutorBuildStage = (byte)-1;
                this.planExecutor = Objects.requireNonNull(ImmutableTableScanContext.super.planExecutor(), "planExecutor");
                this.planExecutorBuildStage = 1;
            }
            return this.planExecutor;
        }

        void planExecutor(ExecutorService planExecutor) {
            this.planExecutor = planExecutor;
            this.planExecutorBuildStage = 1;
        }

        boolean planWithCustomizedExecutor() {
            if (this.planWithCustomizedExecutorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.planWithCustomizedExecutorBuildStage == 0) {
                this.planWithCustomizedExecutorBuildStage = (byte)-1;
                this.planWithCustomizedExecutor = ImmutableTableScanContext.super.planWithCustomizedExecutor();
                this.planWithCustomizedExecutorBuildStage = 1;
            }
            return this.planWithCustomizedExecutor;
        }

        MetricsReporter metricsReporter() {
            if (this.metricsReporterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metricsReporterBuildStage == 0) {
                this.metricsReporterBuildStage = (byte)-1;
                this.metricsReporter = Objects.requireNonNull(ImmutableTableScanContext.super.metricsReporter(), "metricsReporter");
                this.metricsReporterBuildStage = 1;
            }
            return this.metricsReporter;
        }

        void metricsReporter(MetricsReporter metricsReporter) {
            this.metricsReporter = metricsReporter;
            this.metricsReporterBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.rowFilterBuildStage == -1) {
                attributes.add("rowFilter");
            }
            if (this.ignoreResidualsBuildStage == -1) {
                attributes.add("ignoreResiduals");
            }
            if (this.caseSensitiveBuildStage == -1) {
                attributes.add("caseSensitive");
            }
            if (this.returnColumnStatsBuildStage == -1) {
                attributes.add("returnColumnStats");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.fromSnapshotInclusiveBuildStage == -1) {
                attributes.add("fromSnapshotInclusive");
            }
            if (this.planExecutorBuildStage == -1) {
                attributes.add("planExecutor");
            }
            if (this.planWithCustomizedExecutorBuildStage == -1) {
                attributes.add("planWithCustomizedExecutor");
            }
            if (this.metricsReporterBuildStage == -1) {
                attributes.add("metricsReporter");
            }
            return "Cannot build TableScanContext, attribute initializers form cycle " + attributes;
        }
    }
}

