/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class MetricsUtil {
    public static final List<ReadableMetricColDefinition> READABLE_METRIC_COLS = ImmutableList.of((Object)new ReadableMetricColDefinition("column_size", "Total size on disk", DataFile.COLUMN_SIZES, field -> Types.LongType.get(), (file, field) -> file.columnSizes() == null ? null : (Long)file.columnSizes().get(field.fieldId())), (Object)new ReadableMetricColDefinition("value_count", "Total count, including null and NaN", DataFile.VALUE_COUNTS, field -> Types.LongType.get(), (file, field) -> file.valueCounts() == null ? null : (Long)file.valueCounts().get(field.fieldId())), (Object)new ReadableMetricColDefinition("null_value_count", "Null value count", DataFile.NULL_VALUE_COUNTS, field -> Types.LongType.get(), (file, field) -> file.nullValueCounts() == null ? null : (Long)file.nullValueCounts().get(field.fieldId())), (Object)new ReadableMetricColDefinition("nan_value_count", "NaN value count", DataFile.NAN_VALUE_COUNTS, field -> Types.LongType.get(), (file, field) -> file.nanValueCounts() == null ? null : (Long)file.nanValueCounts().get(field.fieldId())), (Object)new ReadableMetricColDefinition("lower_bound", "Lower bound", DataFile.LOWER_BOUNDS, Types.NestedField::type, (file, field) -> file.lowerBounds() == null ? null : Conversions.fromByteBuffer((Type)field.type(), (ByteBuffer)((ByteBuffer)file.lowerBounds().get(field.fieldId())))), (Object)new ReadableMetricColDefinition("upper_bound", "Upper bound", DataFile.UPPER_BOUNDS, Types.NestedField::type, (file, field) -> file.upperBounds() == null ? null : Conversions.fromByteBuffer((Type)field.type(), (ByteBuffer)((ByteBuffer)file.upperBounds().get(field.fieldId())))));
    public static final String READABLE_METRICS = "readable_metrics";

    private MetricsUtil() {
    }

    public static Metrics copyWithoutFieldCounts(Metrics metrics, Set<Integer> excludedFieldIds) {
        return new Metrics(metrics.recordCount(), metrics.columnSizes(), MetricsUtil.copyWithoutKeys(metrics.valueCounts(), excludedFieldIds), MetricsUtil.copyWithoutKeys(metrics.nullValueCounts(), excludedFieldIds), MetricsUtil.copyWithoutKeys(metrics.nanValueCounts(), excludedFieldIds), metrics.lowerBounds(), metrics.upperBounds());
    }

    public static Metrics copyWithoutFieldCountsAndBounds(Metrics metrics, Set<Integer> excludedFieldIds) {
        return new Metrics(metrics.recordCount(), metrics.columnSizes(), MetricsUtil.copyWithoutKeys(metrics.valueCounts(), excludedFieldIds), MetricsUtil.copyWithoutKeys(metrics.nullValueCounts(), excludedFieldIds), MetricsUtil.copyWithoutKeys(metrics.nanValueCounts(), excludedFieldIds), MetricsUtil.copyWithoutKeys(metrics.lowerBounds(), excludedFieldIds), MetricsUtil.copyWithoutKeys(metrics.upperBounds(), excludedFieldIds));
    }

    private static <K, V> Map<K, V> copyWithoutKeys(Map<K, V> map, Set<K> keys) {
        if (map == null) {
            return null;
        }
        HashMap filteredMap = Maps.newHashMap(map);
        for (K key : keys) {
            filteredMap.remove(key);
        }
        return filteredMap.isEmpty() ? null : filteredMap;
    }

    public static Map<Integer, Long> createNanValueCounts(Stream<FieldMetrics<?>> fieldMetrics, MetricsConfig metricsConfig, Schema inputSchema) {
        Preconditions.checkNotNull((Object)metricsConfig, (Object)"metricsConfig is required");
        if (fieldMetrics == null || inputSchema == null) {
            return Maps.newHashMap();
        }
        return fieldMetrics.filter(metrics -> MetricsUtil.metricsMode(inputSchema, metricsConfig, metrics.id()) != MetricsModes.None.get()).collect(Collectors.toMap(FieldMetrics::id, FieldMetrics::nanValueCount));
    }

    public static MetricsModes.MetricsMode metricsMode(Schema inputSchema, MetricsConfig metricsConfig, int fieldId) {
        Preconditions.checkNotNull((Object)inputSchema, (Object)"inputSchema is required");
        Preconditions.checkNotNull((Object)metricsConfig, (Object)"metricsConfig is required");
        String columnName = inputSchema.findColumnName(fieldId);
        return metricsConfig.columnMode(columnName);
    }

    public static Schema readableMetricsSchema(Schema dataTableSchema, Schema metadataTableSchema) {
        ArrayList fields = Lists.newArrayList();
        Map idToName = dataTableSchema.idToName();
        AtomicInteger nextId = new AtomicInteger(metadataTableSchema.highestFieldId());
        Iterator iterator = idToName.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            Types.NestedField field = dataTableSchema.findField(id);
            if (!field.type().isPrimitiveType()) continue;
            String colName = (String)idToName.get(id);
            fields.add(Types.NestedField.of((int)nextId.incrementAndGet(), (boolean)true, (String)colName, (Type)Types.StructType.of(READABLE_METRIC_COLS.stream().map(m -> Types.NestedField.optional((int)nextId.incrementAndGet(), (String)m.name(), (Type)m.colType(field), (String)m.doc())).collect(Collectors.toList())), (String)String.format("Metrics for column %s", colName)));
        }
        fields.sort(Comparator.comparing(Types.NestedField::name));
        return new Schema(new Types.NestedField[]{Types.NestedField.optional((int)nextId.incrementAndGet(), (String)READABLE_METRICS, (Type)Types.StructType.of((List)fields), (String)"Column metrics in readable form")});
    }

    public static ReadableMetricsStruct readableMetricsStruct(Schema schema, ContentFile<?> file, Types.StructType projectedSchema) {
        Map idToName = schema.idToName();
        ArrayList colMetrics = Lists.newArrayList();
        Iterator iterator = idToName.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            String qualifiedName = (String)idToName.get(id);
            Types.NestedField field = schema.findField(id);
            Object[] metrics = READABLE_METRIC_COLS.stream().map(readableMetric -> readableMetric.value(file, field)).toArray();
            if (!field.type().isPrimitiveType() || projectedSchema.field(qualifiedName) == null) continue;
            colMetrics.add(new ReadableColMetricsStruct(qualifiedName, projectedSchema.field(qualifiedName), metrics));
        }
        colMetrics.sort(Comparator.comparing(ReadableColMetricsStruct::columnName));
        return new ReadableMetricsStruct(colMetrics.stream().map(m -> m).collect(Collectors.toList()));
    }

    static class StructWithReadableMetrics
    implements StructLike {
        private final StructLike struct;
        private final ReadableMetricsStruct readableMetrics;
        private final int projectionColumnCount;
        private final int metricsPosition;

        StructWithReadableMetrics(StructLike struct, int structSize, ReadableMetricsStruct readableMetrics, int metricsPosition) {
            this.struct = struct;
            this.readableMetrics = readableMetrics;
            this.projectionColumnCount = structSize;
            this.metricsPosition = metricsPosition;
        }

        public int size() {
            return this.projectionColumnCount;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            if (pos < this.metricsPosition) {
                return (T)this.struct.get(pos, javaClass);
            }
            if (pos == this.metricsPosition) {
                return javaClass.cast(this.readableMetrics);
            }
            return (T)this.struct.get(pos - 1, javaClass);
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("StructWithReadableMetrics is read only");
        }
    }

    public static class ReadableMetricsStruct
    implements StructLike {
        private final List<StructLike> columnMetrics;

        public ReadableMetricsStruct(List<StructLike> columnMetrics) {
            this.columnMetrics = columnMetrics;
        }

        public int size() {
            return this.columnMetrics.size();
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.columnMetrics.get(pos));
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("ReadableMetricsStruct is read only");
        }
    }

    public static class ReadableColMetricsStruct
    implements StructLike {
        private final String columnName;
        private final Map<Integer, Integer> projectionMap;
        private final Object[] metrics;

        public ReadableColMetricsStruct(String columnName, Types.NestedField projection, Object ... metrics) {
            this.columnName = columnName;
            this.projectionMap = this.readableMetricsProjection(projection);
            this.metrics = metrics;
        }

        public int size() {
            return this.projectionMap.size();
        }

        public <T> T get(int pos, Class<T> javaClass) {
            Object value = this.get(pos);
            return value == null ? null : (T)javaClass.cast(value);
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("ReadableColMetricsStruct is read only");
        }

        private Object get(int pos) {
            int projectedPos = this.projectionMap.get(pos);
            return this.metrics[projectedPos];
        }

        private Map<Integer, Integer> readableMetricsProjection(Types.NestedField projection) {
            HashMap result = Maps.newHashMap();
            HashSet projectedFields = Sets.newHashSet((Iterable)projection.type().asStructType().fields().stream().map(Types.NestedField::name).collect(Collectors.toSet()));
            int projectedIndex = 0;
            for (int fieldIndex = 0; fieldIndex < READABLE_METRIC_COLS.size(); ++fieldIndex) {
                ReadableMetricColDefinition readableMetric = READABLE_METRIC_COLS.get(fieldIndex);
                if (!projectedFields.contains(readableMetric.name())) continue;
                result.put(projectedIndex, fieldIndex);
                ++projectedIndex;
            }
            return result;
        }

        String columnName() {
            return this.columnName;
        }
    }

    public static class ReadableMetricColDefinition {
        private final String name;
        private final String doc;
        private final Types.NestedField originalCol;
        private final TypeFunction typeFunction;
        private final MetricFunction metricFunction;

        ReadableMetricColDefinition(String name, String doc, Types.NestedField originalCol, TypeFunction typeFunction, MetricFunction metricFunction) {
            this.name = name;
            this.doc = doc;
            this.originalCol = originalCol;
            this.typeFunction = typeFunction;
            this.metricFunction = metricFunction;
        }

        Types.NestedField originalCol() {
            return this.originalCol;
        }

        Type colType(Types.NestedField field) {
            return this.typeFunction.type(field);
        }

        String name() {
            return this.name;
        }

        String doc() {
            return this.doc;
        }

        Object value(ContentFile<?> dataFile, Types.NestedField dataField) {
            return this.metricFunction.metric(dataFile, dataField);
        }

        public static interface MetricFunction {
            public Object metric(ContentFile<?> var1, Types.NestedField var2);
        }

        public static interface TypeFunction {
            public Type type(Types.NestedField var1);
        }
    }
}

