/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.jets3t.service.io.InputStreamWrapper;

public class GZipDeflatingInputStream
extends InputStream
implements InputStreamWrapper {
    private int BUFFER_SIZE = 8192;
    Deflater deflater = new Deflater(-1, true);
    private InputStream inputStream = null;
    private byte[] buffer = new byte[this.BUFFER_SIZE];
    private byte[] deflatedBytes = new byte[this.BUFFER_SIZE];
    private CRC32 crc = new CRC32();
    int bufferOffset = 0;
    int bufferEnd = 0;
    boolean EOFInput = false;
    boolean EOFDeflated = false;
    boolean EOFTail = false;

    public GZipDeflatingInputStream(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.crc.reset();
        int GZIP_MAGIC = 35615;
        this.writeShort(GZIP_MAGIC);
        this.deflatedBytes[this.bufferEnd++] = 8;
        this.deflatedBytes[this.bufferEnd++] = 0;
        this.writeInt(0);
        this.deflatedBytes[this.bufferEnd++] = 0;
        this.deflatedBytes[this.bufferEnd++] = 0;
    }

    private void primeDeflateBuffer() throws IOException {
        this.bufferEnd = 0;
        while (this.bufferEnd == 0) {
            if (!this.deflater.needsInput()) {
                this.bufferEnd = this.deflater.deflate(this.deflatedBytes);
                this.bufferOffset = 0;
                continue;
            }
            if (!this.EOFInput) {
                int byteCount = this.inputStream.read(this.buffer, 0, this.buffer.length);
                if (byteCount > 0) {
                    this.crc.update(this.buffer, 0, byteCount);
                    this.deflater.setInput(this.buffer, 0, byteCount);
                    this.bufferEnd = this.deflater.deflate(this.deflatedBytes);
                    this.bufferOffset = 0;
                    continue;
                }
                if (byteCount == 0) continue;
                this.deflater.finish();
                this.EOFInput = true;
                this.bufferEnd = 0;
                this.bufferOffset = 0;
                continue;
            }
            if (!this.deflater.finished()) {
                this.bufferEnd = this.deflater.deflate(this.deflatedBytes);
                this.bufferOffset = 0;
                continue;
            }
            if (!this.EOFDeflated) {
                this.EOFDeflated = true;
                this.bufferOffset = 0;
                this.bufferEnd = 0;
                this.writeInt((int)this.crc.getValue());
                this.writeInt(this.deflater.getTotalIn());
                continue;
            }
            this.EOFTail = true;
            return;
        }
    }

    private int getDeflatedBufferAvail() {
        return this.bufferEnd - this.bufferOffset;
    }

    public int read() throws IOException {
        if (this.getDeflatedBufferAvail() == 0) {
            this.primeDeflateBuffer();
        }
        if (this.EOFTail) {
            return -1;
        }
        return this.deflatedBytes[this.bufferOffset++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.getDeflatedBufferAvail() == 0) {
            this.primeDeflateBuffer();
        }
        if (this.EOFTail) {
            return -1;
        }
        if (len > this.getDeflatedBufferAvail()) {
            int bytesAvailable = this.getDeflatedBufferAvail();
            System.arraycopy(this.deflatedBytes, this.bufferOffset, b, off, bytesAvailable);
            this.bufferOffset = 0;
            this.bufferEnd = 0;
            return bytesAvailable;
        }
        System.arraycopy(this.deflatedBytes, this.bufferOffset, b, off, len);
        this.bufferOffset += len;
        return len;
    }

    public int available() throws IOException {
        if (this.EOFTail) {
            return -1;
        }
        if (this.getDeflatedBufferAvail() == 0) {
            this.primeDeflateBuffer();
        }
        return this.getDeflatedBufferAvail();
    }

    public void close() throws IOException {
        this.EOFTail = true;
        this.inputStream.close();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }

    private void writeInt(int i) {
        this.writeShort(i & 0xFFFF);
        this.writeShort(i >> 16 & 0xFFFF);
    }

    private void writeShort(int s) {
        this.deflatedBytes[this.bufferEnd++] = (byte)(s & 0xFF);
        this.deflatedBytes[this.bufferEnd++] = (byte)(s >> 8 & 0xFF);
    }
}

