/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.transports.CompositeConfig;
import io.openlineage.client.transports.Transport;
import io.openlineage.client.transports.TransportConfig;
import io.openlineage.client.transports.TransportResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTransport
extends Transport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeTransport.class);
    private final CompositeConfig config;
    private final List<Transport> transports = new ArrayList<Transport>();
    private final Optional<ExecutorService> executorService;

    public CompositeTransport(@NonNull CompositeConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.initializeTransports();
        this.executorService = config.getWithThreadPool() != false ? Optional.of(Executors.newFixedThreadPool(this.transports.size())) : Optional.empty();
    }

    private void initializeTransports() {
        for (TransportConfig transportConfig : this.config.getTransports()) {
            Transport transport = TransportResolver.resolveTransportByConfig(transportConfig);
            this.transports.add(transport);
        }
    }

    public List<Transport> getTransports() {
        return this.transports;
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        this.doEmit(runEvent);
    }

    @Override
    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        this.doEmit(datasetEvent);
    }

    @Override
    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        this.doEmit(jobEvent);
    }

    private void doEmit(OpenLineage.BaseEvent event) {
        if (!this.config.getContinueOnFailure().booleanValue()) {
            for (Transport transport : this.transports) {
                this.emit(transport, event);
            }
        } else {
            ExecutorService threadPool = this.executorService.orElse(Executors.newFixedThreadPool(this.transports.size()));
            try {
                threadPool.invokeAll(this.transports.stream().map(t -> () -> {
                    this.emit((Transport)t, event);
                    return null;
                }).collect(Collectors.toList())).forEach(f -> {
                    try {
                        f.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!this.config.getWithThreadPool().booleanValue()) {
                    threadPool.shutdown();
                }
            }
        }
    }

    private void emit(Transport transport, OpenLineage.BaseEvent event) {
        block5: {
            try {
                if (event instanceof OpenLineage.RunEvent) {
                    transport.emit((OpenLineage.RunEvent)event);
                    break block5;
                }
                if (event instanceof OpenLineage.DatasetEvent) {
                    transport.emit((OpenLineage.DatasetEvent)event);
                    break block5;
                }
                if (event instanceof OpenLineage.JobEvent) {
                    transport.emit((OpenLineage.JobEvent)event);
                    break block5;
                }
                throw new IllegalArgumentException("Unsupported event type: " + event.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Transport " + transport.getClass().getSimpleName() + " failed to emit event", e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.executorService.ifPresent(ExecutorService::shutdown);
        this.transports.forEach(t -> {
            try {
                t.close();
            }
            catch (Exception e) {
                log.error("Failed to close {} transport", (Object)t.getClass().getSimpleName(), (Object)e);
                throw new OpenLineageClientException(e);
            }
        });
    }
}

