/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.provider.token;

import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;

public class JwtAuthToken
implements AuthToken {
    private static final String SUBJECT_CLAIM = "sub";
    private static final String ISSUER_CLAIM = "iss";
    private static final String AUDIENCE_CLAIM = "aud";
    private static final String EXPIRY_CLAIM = "exp";
    private static final String NOT_BEFORE_CLAIM = "nbf";
    private static final String ISSUED_AT_CLAIM = "iat";
    private static final String ID_CLAIM = "jti";
    private Boolean isIdToken = true;
    private Boolean isAcToken = false;
    private final Map<String, Object> claims = new HashMap<String, Object>();

    public JwtAuthToken() {
    }

    public JwtAuthToken(JWTClaimsSet jwtClaims) {
        if (jwtClaims != null) {
            this.claims.putAll(jwtClaims.getClaims());
        }
    }

    protected JWT getJwt() {
        String jti = (String)this.claims.get(ID_CLAIM);
        if (jti == null || jti.isEmpty()) {
            jti = UUID.randomUUID().toString();
            this.claims.put(ID_CLAIM, jti);
        }
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        for (Map.Entry<String, Object> entry : this.claims.entrySet()) {
            builder = builder.claim(entry.getKey(), entry.getValue());
        }
        PlainHeader header = new PlainHeader();
        PlainJWT jwt = new PlainJWT(header, builder.build());
        return jwt;
    }

    public String getSubject() {
        return (String)this.claims.get(SUBJECT_CLAIM);
    }

    public void setSubject(String sub) {
        this.claims.put(SUBJECT_CLAIM, sub);
    }

    public String getIssuer() {
        return (String)this.claims.get(ISSUER_CLAIM);
    }

    public void setIssuer(String issuer) {
        this.claims.put(ISSUER_CLAIM, issuer);
    }

    public List<String> getAudiences() {
        return (List)this.claims.get(AUDIENCE_CLAIM);
    }

    public void setAudiences(List<String> audiences) {
        this.claims.put(AUDIENCE_CLAIM, audiences);
    }

    public boolean isIdToken() {
        return this.isIdToken;
    }

    public void isIdToken(boolean isIdToken) {
        this.isIdToken = isIdToken;
    }

    public boolean isAcToken() {
        return this.isAcToken;
    }

    public void isAcToken(boolean isAcToken) {
        this.isAcToken = isAcToken;
    }

    public boolean isBearerToken() {
        return true;
    }

    public boolean isHolderOfKeyToken() {
        return false;
    }

    public Date getExpiredTime() {
        return (Date)this.claims.get(EXPIRY_CLAIM);
    }

    public void setExpirationTime(Date exp) {
        this.claims.put(EXPIRY_CLAIM, exp);
    }

    public Date getNotBeforeTime() {
        return (Date)this.claims.get(NOT_BEFORE_CLAIM);
    }

    public void setNotBeforeTime(Date nbt) {
        this.claims.put(NOT_BEFORE_CLAIM, nbt);
    }

    public Date getIssueTime() {
        return (Date)this.claims.get(ISSUED_AT_CLAIM);
    }

    public void setIssueTime(Date iat) {
        this.claims.put(ISSUED_AT_CLAIM, iat);
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.claims);
    }

    public void addAttribute(String name, Object value) {
        this.claims.put(name, value);
    }
}

