/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.Properties;
import org.apache.gravitino.cli.commands.Command;

public class ModelCommandHandler
extends CommandHandler {
    private static final String DELIMITER = ",";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private final String catalog;
    private final String schema;
    private String model;

    public ModelCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
        this.catalog = this.name.getCatalogName();
        this.schema = this.name.getSchemaName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        ArrayList<String> missingEntities = Lists.newArrayList();
        if (this.catalog == null) {
            missingEntities.add("catalog");
        }
        if (this.schema == null) {
            missingEntities.add("schema");
        }
        if ("list".equals(this.command)) {
            this.checkEntities(missingEntities);
            this.handleListCommand();
            return;
        }
        this.model = this.name.getModelName();
        if (this.model == null) {
            missingEntities.add("model");
        }
        this.checkEntities(missingEntities);
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newModelAudit(this.context, this.metalake, this.catalog, this.schema, this.model).validate().handle();
        } else {
            this.gravitinoCommandLine.newModelDetails(this.context, this.metalake, this.catalog, this.schema, this.model).validate().handle();
        }
    }

    private void handleCreateCommand() {
        String createComment = this.line.getOptionValue("comment");
        String[] createProperties = this.line.getOptionValues("properties");
        Map<String, String> createPropertyMap = new Properties().parse(createProperties);
        this.gravitinoCommandLine.newCreateModel(this.context, this.metalake, this.catalog, this.schema, this.model, createComment, createPropertyMap).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteModel(this.context, this.metalake, this.catalog, this.schema, this.model).validate().handle();
    }

    private void handleUpdateCommand() {
        String alias;
        Integer version;
        if (this.line.hasOption("uris")) {
            String[] alias2 = this.line.getOptionValues("alias");
            Map<String, String> uris = this.getUrisFromLime(this.line);
            String linkComment = this.line.getOptionValue("comment");
            String[] linkProperties = this.line.getOptionValues("properties");
            Map<String, String> linkPropertityMap = new Properties().parse(linkProperties);
            this.gravitinoCommandLine.newLinkModel(this.context, this.metalake, this.catalog, this.schema, this.model, uris, alias2, linkComment, linkPropertityMap).validate().handle();
        }
        if (this.line.hasOption("rename")) {
            String newName = this.line.getOptionValue("rename");
            this.gravitinoCommandLine.newUpdateModelName(this.context, this.metalake, this.catalog, this.schema, this.model, newName).validate().handle();
        }
        if (this.line.hasOption("comment") && !this.line.hasOption("alias") && !this.line.hasOption("version")) {
            String newComment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateModelComment(this.context, this.metalake, this.catalog, this.schema, this.model, newComment).validate().handle();
        }
        if (!this.line.hasOption("uris") && this.line.hasOption("comment") && (this.line.hasOption("alias") || this.line.hasOption("version"))) {
            String comment = this.line.getOptionValue("comment");
            version = this.getVersionFromLine(this.line);
            alias = this.getAliasFromLine(this.line);
            this.gravitinoCommandLine.newUpdateModelVersionComment(this.context, this.metalake, this.catalog, this.schema, this.model, version, alias, comment).validate().handle();
        }
        if (this.line.hasOption("newuri") && (this.line.hasOption("alias") || this.line.hasOption("version"))) {
            String newUri = this.line.getOptionValue("newuri");
            version = this.getVersionFromLine(this.line);
            alias = this.getAliasFromLine(this.line);
            this.gravitinoCommandLine.newUpdateModelVersionUri(this.context, this.metalake, this.catalog, this.schema, this.model, version, alias, newUri).validate().handle();
        }
        if (this.line.hasOption("newalias") && (this.line.hasOption("alias") || this.line.hasOption("version"))) {
            String[] newAliases = this.line.getOptionValues("newalias");
            version = this.getVersionFromLine(this.line);
            alias = this.getAliasFromLine(this.line);
            this.gravitinoCommandLine.newUpdateModelVersionAliases(this.context, this.metalake, this.catalog, this.schema, this.model, version, alias, newAliases, new String[0]).validate().handle();
        }
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListModel(this.context, this.metalake, this.catalog, this.schema).validate().handle();
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        if (this.line.hasOption("alias") || this.line.hasOption("version")) {
            Integer version = this.getVersionFromLine(this.line);
            String alias = this.getAliasFromLine(this.line);
            this.gravitinoCommandLine.newSetModelVersionProperty(this.context, this.metalake, this.catalog, this.schema, this.model, version, alias, property, value).validate().handle();
        } else {
            this.gravitinoCommandLine.newSetModelProperty(this.context, this.metalake, this.catalog, this.schema, this.model, property, value).validate().handle();
        }
    }

    private void handleRemoveCommand() {
        String property = this.line.getOptionValue("property");
        if (this.line.hasOption("removealias") && (this.line.hasOption("alias") || this.line.hasOption("version"))) {
            String[] removeAliases = this.line.getOptionValues("removealias");
            Integer version = this.getVersionFromLine(this.line);
            String alias = this.getAliasFromLine(this.line);
            this.gravitinoCommandLine.newUpdateModelVersionAliases(this.context, this.metalake, this.catalog, this.schema, this.model, version, alias, new String[0], removeAliases).validate().handle();
        } else if (this.line.hasOption("alias") || this.line.hasOption("version")) {
            Integer version = this.getVersionFromLine(this.line);
            String alias = this.getAliasFromLine(this.line);
            this.gravitinoCommandLine.newRemoveModelVersionProperty(this.context, this.metalake, this.catalog, this.schema, this.model, version, alias, property).validate().handle();
        } else {
            this.gravitinoCommandLine.newRemoveModelProperty(this.context, this.metalake, this.catalog, this.schema, this.model, property).validate().handle();
        }
    }

    private String getOneAlias(String[] aliases) {
        if (aliases == null || aliases.length > 1) {
            System.err.println("This command only supports one --alias option.");
            Main.exit(-1);
        }
        return aliases[0];
    }

    private Integer getVersionFromLine(CommandLine line) {
        return line.hasOption("version") ? Integer.valueOf(Integer.parseInt(line.getOptionValue("version"))) : null;
    }

    private String getAliasFromLine(CommandLine line) {
        return line.hasOption("alias") ? this.getOneAlias(line.getOptionValues("alias")) : null;
    }

    private Map<String, String> getUrisFromLime(CommandLine line) {
        String input = line.getOptionValue("uris");
        ImmutableMap.Builder<String, String> uris = ImmutableMap.builder();
        if (input != null) {
            String[] pairs;
            for (String pair : pairs = input.split(DELIMITER)) {
                String[] keyValue = pair.split(KEY_VALUE_SEPARATOR, 2);
                if (keyValue.length != 2) continue;
                uris.put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        return uris.build();
    }
}

