/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.DefaultConverter;
import org.apache.gravitino.cli.ParseType;
import org.apache.gravitino.cli.PositionConverter;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.types.Type;

public class AddColumn
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;
    protected final String column;
    protected final String datatype;
    protected final String comment;
    protected final String position;
    protected final boolean nullable;
    protected final boolean autoIncrement;
    protected final String defaultValue;

    public AddColumn(CommandContext context, String metalake, String catalog, String schema, String table, String column, String datatype, String comment, String position, boolean nullable, boolean autoIncrement, String defaultValue) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.column = column;
        this.datatype = datatype;
        this.comment = comment;
        this.position = position;
        this.nullable = nullable;
        this.autoIncrement = autoIncrement;
        this.defaultValue = defaultValue;
    }

    @Override
    public void handle() {
        String[] columns = new String[]{this.column};
        Type convertedDatatype = ParseType.toType(this.datatype);
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            TableChange change = TableChange.addColumn(columns, convertedDatatype, this.comment, PositionConverter.convert(this.position), this.nullable, this.autoIncrement, DefaultConverter.convert(this.defaultValue, this.datatype));
            client.loadCatalog(this.catalog).asTableCatalog().alterTable(name, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.column + " added to table " + this.table + ".");
    }
}

