/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.FilesetChange;

public class UpdateFilesetComment
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String fileset;
    protected final String comment;

    public UpdateFilesetComment(CommandContext context, String metalake, String catalog, String schema, String fileset, String comment) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.fileset = fileset;
        this.comment = comment;
    }

    @Override
    public void handle() {
        try {
            NameIdentifier filesetName = NameIdentifier.of(this.schema, this.fileset);
            GravitinoClient client = this.buildClient(this.metalake);
            FilesetChange change = FilesetChange.updateComment(this.comment);
            client.loadCatalog(this.catalog).asFilesetCatalog().alterFileset(filesetName, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchFilesetException err) {
            this.exitWithError("Unknown fileset name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.fileset + " comment changed.");
    }
}

