/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.collect.ImmutableMap;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.storage.relational.RelationalEntityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EntityStoreFactory.class);
    public static final ImmutableMap<String, String> ENTITY_STORES = ImmutableMap.of((Object)"relational", (Object)RelationalEntityStore.class.getCanonicalName());

    private EntityStoreFactory() {
    }

    public static EntityStore createEntityStore(Config config) {
        String name = (String)config.get(Configs.ENTITY_STORE);
        String className = (String)ENTITY_STORES.getOrDefault((Object)name, (Object)name);
        try {
            return (EntityStore)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Failed to create and initialize EntityStore by name {}.", (Object)name, (Object)e);
            throw new RuntimeException("Failed to create and initialize EntityStore: " + name, e);
        }
    }
}

