/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.time.ZoneId;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.DateTimeUtils;

public class NumericPrimitiveToTimestamp
extends AbstractCastRule<Number, Timestamp> {
    static final NumericPrimitiveToTimestamp INSTANCE = new NumericPrimitiveToTimestamp();

    private NumericPrimitiveToTimestamp() {
        super(CastRulePredicate.builder().input(DataTypeFamily.NUMERIC).target(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).target(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build());
    }

    @Override
    public CastExecutor<Number, Timestamp> create(DataType inputType, DataType targetType) {
        ZoneId zoneId = targetType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) ? ZoneId.systemDefault() : DateTimeUtils.UTC_ZONE.toZoneId();
        switch (inputType.getTypeRoot()) {
            case INTEGER: 
            case BIGINT: {
                return value -> Timestamp.fromLocalDateTime(DateTimeUtils.toLocalDateTime(value.longValue() * 1000L, zoneId));
            }
        }
        return null;
    }
}

