/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.DateTimeUtils;

class TimeToStringCastRule
extends AbstractCastRule<Integer, BinaryString> {
    static final TimeToStringCastRule INSTANCE = new TimeToStringCastRule();

    private TimeToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.TIME_WITHOUT_TIME_ZONE).target((DataType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public CastExecutor<Integer, BinaryString> create(DataType inputType, DataType targetType) {
        return value -> BinaryString.fromString(DateTimeUtils.formatTimestampMillis(value, DataTypeChecks.getPrecision((DataType)inputType)));
    }
}

