/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.bitmap;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.utils.RoaringBitmap32;

public class ApplyBitmapIndexFileRecordIterator
implements FileRecordIterator<InternalRow> {
    private final FileRecordIterator<InternalRow> iterator;
    private final RoaringBitmap32 bitmap;
    private final int last;

    public ApplyBitmapIndexFileRecordIterator(FileRecordIterator<InternalRow> iterator, BitmapIndexResult fileIndexResult) {
        this.iterator = iterator;
        this.bitmap = (RoaringBitmap32)fileIndexResult.get();
        this.last = this.bitmap.last();
    }

    @Override
    public long returnedPosition() {
        return this.iterator.returnedPosition();
    }

    @Override
    public Path filePath() {
        return this.iterator.filePath();
    }

    @Override
    @Nullable
    public InternalRow next() throws IOException {
        InternalRow next;
        int position;
        do {
            if ((next = (InternalRow)this.iterator.next()) == null) {
                return null;
            }
            position = (int)this.returnedPosition();
            if (position <= this.last) continue;
            return null;
        } while (!this.bitmap.contains(position));
        return next;
    }

    @Override
    public void releaseBatch() {
        this.iterator.releaseBatch();
    }
}

