/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.hll;

import org.apache.paimon.shade.org.apache.datasketches.common.SketchesStateException;
import org.apache.paimon.shade.org.apache.datasketches.hll.DirectHllArray;
import org.apache.paimon.shade.org.apache.datasketches.hll.Hll8Array;
import org.apache.paimon.shade.org.apache.datasketches.hll.HllPairIterator;
import org.apache.paimon.shade.org.apache.datasketches.hll.HllSketchImpl;
import org.apache.paimon.shade.org.apache.datasketches.hll.HllUtil;
import org.apache.paimon.shade.org.apache.datasketches.hll.PairIterator;
import org.apache.paimon.shade.org.apache.datasketches.hll.PreambleUtil;
import org.apache.paimon.shade.org.apache.datasketches.hll.TgtHllType;
import org.apache.paimon.shade.org.apache.datasketches.memory.Memory;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableMemory;

class DirectHll8Array
extends DirectHllArray {
    DirectHll8Array(int lgConfigK, WritableMemory wmem) {
        super(lgConfigK, TgtHllType.HLL_8, wmem);
    }

    DirectHll8Array(int lgConfigK, Memory mem) {
        super(lgConfigK, TgtHllType.HLL_8, mem);
    }

    @Override
    HllSketchImpl copy() {
        return Hll8Array.heapify(this.mem);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        int newValue = HllUtil.getPairValue(coupon);
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getPairLow26(coupon) & configKmask;
        this.updateSlotWithKxQ(slotNo, newValue);
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll8Array.hll8ArrBytes(this.lgConfigK);
    }

    @Override
    int getNibble(int slotNo) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    final int getSlotValue(int slotNo) {
        return this.mem.getByte(PreambleUtil.HLL_BYTE_ARR_START + slotNo) & 0x3F;
    }

    @Override
    PairIterator iterator() {
        return new DirectHll8Iterator(1 << this.lgConfigK);
    }

    @Override
    void putNibble(int slotNo, int nibValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    final void updateSlotNoKxQ(int slotNo, int newValue) {
        int oldValue = this.getSlotValue(slotNo);
        if (newValue > oldValue) {
            this.wmem.putByte(PreambleUtil.HLL_BYTE_ARR_START + slotNo, (byte)(newValue & 0x3F));
        }
    }

    @Override
    final void updateSlotWithKxQ(int slotNo, int newValue) {
        int oldValue = this.getSlotValue(slotNo);
        if (newValue > oldValue) {
            this.wmem.putByte(PreambleUtil.HLL_BYTE_ARR_START + slotNo, (byte)(newValue & 0x3F));
            DirectHll8Array.hipAndKxQIncrementalUpdate(this, oldValue, newValue);
            if (oldValue == 0) {
                this.decNumAtCurMin();
                assert (this.getNumAtCurMin() >= 0);
            }
        }
    }

    final class DirectHll8Iterator
    extends HllPairIterator {
        DirectHll8Iterator(int lengthPairs) {
            super(lengthPairs);
        }

        @Override
        int value() {
            byte tmp = DirectHll8Array.this.mem.getByte(PreambleUtil.HLL_BYTE_ARR_START + this.index);
            return tmp & 0x3F;
        }
    }
}

