/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.ops.IcebergCatalogWrapper;
import org.apache.gravitino.iceberg.service.CatalogWrapperForREST;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.provider.IcebergConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogWrapperManager
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(IcebergCatalogWrapperManager.class);
    private final Cache<String, CatalogWrapperForREST> icebergCatalogWrapperCache;
    private final IcebergConfigProvider configProvider;

    public IcebergCatalogWrapperManager(Map<String, String> properties, IcebergConfigProvider configProvider) {
        this.configProvider = configProvider;
        this.icebergCatalogWrapperCache = Caffeine.newBuilder().expireAfterWrite(((Long)new IcebergConfig(properties).get(IcebergConfig.ICEBERG_REST_CATALOG_CACHE_EVICTION_INTERVAL)).longValue(), TimeUnit.MILLISECONDS).removalListener((k, v, c) -> {
            String catalogName = (String)k;
            LOG.info("Remove IcebergCatalogWrapper cache {}.", (Object)catalogName);
            this.closeIcebergCatalogWrapper((IcebergCatalogWrapper)v);
        }).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("iceberg-catalog-wrapper-cleaner-%d").build()))).build();
    }

    public CatalogWrapperForREST getOps(String rawPrefix) {
        String catalogName = IcebergRestUtils.getCatalogName(rawPrefix);
        return this.getCatalogWrapper(catalogName);
    }

    public CatalogWrapperForREST getCatalogWrapper(String catalogName) {
        CatalogWrapperForREST catalogWrapperForREST = (CatalogWrapperForREST)((Object)this.icebergCatalogWrapperCache.get((Object)catalogName, k -> this.createCatalogWrapper(catalogName)));
        catalogWrapperForREST.reloadHadoopConf();
        return catalogWrapperForREST;
    }

    private CatalogWrapperForREST createCatalogWrapper(String catalogName) {
        Optional<IcebergConfig> icebergConfig = this.configProvider.getIcebergCatalogConfig(catalogName);
        if (!icebergConfig.isPresent()) {
            throw new NoSuchCatalogException("Couldn't find Iceberg configuration for catalog %s", new Object[]{catalogName});
        }
        return this.createCatalogWrapper(catalogName, icebergConfig.get());
    }

    @VisibleForTesting
    protected CatalogWrapperForREST createCatalogWrapper(String catalogName, IcebergConfig icebergConfig) {
        return new CatalogWrapperForREST(catalogName, icebergConfig);
    }

    private void closeIcebergCatalogWrapper(IcebergCatalogWrapper catalogWrapper) {
        try {
            catalogWrapper.close();
        }
        catch (Exception ex) {
            LOG.warn("Close Iceberg table catalog wrapper fail: {}, {}", (Object)catalogWrapper, (Object)ex);
        }
    }

    @Override
    public void close() throws Exception {
        this.icebergCatalogWrapperCache.invalidateAll();
    }
}

