/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.gravitino.exceptions.IllegalNameIdentifierException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.exceptions.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class IcebergExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergExceptionMapper.class);
    private static final Map<Class<? extends Exception>, Integer> EXCEPTION_ERROR_CODES = ImmutableMap.builder().put(IllegalArgumentException.class, (Object)400).put(ValidationException.class, (Object)400).put(IllegalNameIdentifierException.class, (Object)400).put(NamespaceNotEmptyException.class, (Object)400).put(NotAuthorizedException.class, (Object)401).put(org.apache.gravitino.exceptions.ForbiddenException.class, (Object)403).put(ForbiddenException.class, (Object)403).put(NoSuchNamespaceException.class, (Object)404).put(NoSuchTableException.class, (Object)404).put(NoSuchIcebergTableException.class, (Object)404).put(NoSuchCatalogException.class, (Object)404).put(UnsupportedOperationException.class, (Object)406).put(NoSuchViewException.class, (Object)404).put(AlreadyExistsException.class, (Object)409).put(CommitFailedException.class, (Object)409).put(UnprocessableEntityException.class, (Object)422).put(CommitStateUnknownException.class, (Object)500).put(ServiceUnavailableException.class, (Object)503).build();

    public Response toResponse(Exception ex) {
        return IcebergExceptionMapper.toRESTResponse(ex);
    }

    public static Response toRESTResponse(Exception ex) {
        int status = EXCEPTION_ERROR_CODES.getOrDefault(ex.getClass(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        if (status == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            LOG.warn("Iceberg REST server unexpected exception:", (Throwable)ex);
        } else {
            LOG.info("Iceberg REST server error maybe caused by user request, response http status: {}, exception: {}, exception message: {}", new Object[]{status, ex.getClass(), ex.getMessage()});
        }
        return IcebergRestUtils.errorResponse(ex, status);
    }
}

