/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.CachedConnectionStrategy;
import com.jolbox.bonecp.CloseThreadMonitor;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionMaxAgeThread;
import com.jolbox.bonecp.ConnectionPartition;
import com.jolbox.bonecp.ConnectionStrategy;
import com.jolbox.bonecp.ConnectionTesterThread;
import com.jolbox.bonecp.CustomThreadFactory;
import com.jolbox.bonecp.DefaultConnectionStrategy;
import com.jolbox.bonecp.PoolUtil;
import com.jolbox.bonecp.PoolWatchThread;
import com.jolbox.bonecp.Statistics;
import com.jolbox.bonecp.hooks.AcquireFailConfig;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneCP
implements Serializable,
Closeable {
    private static final String THREAD_CLOSE_CONNECTION_WARNING = "Thread close connection monitoring has been enabled. This will negatively impact on your performance. Only enable this option for debugging purposes!";
    private static final long serialVersionUID = -8386816681977604817L;
    private static final String ERROR_TEST_CONNECTION = "Unable to open a test connection to the given database. JDBC url = %s, username = %s. Terminating connection pool (set lazyInit to true if you expect to start your database after your app). Original Exception: %s";
    private static final String SHUTDOWN_LOCATION_TRACE = "Attempting to obtain a connection from a pool that has already been shutdown. \nStack trace of location where pool was shutdown follows:\n";
    private static final String UNCLOSED_EXCEPTION_MESSAGE = "Connection obtained from thread [%s] was never closed. \nStack trace of location where connection was obtained follows:\n";
    public static final String MBEAN_CONFIG = "com.jolbox.bonecp:type=BoneCPConfig";
    public static final String MBEAN_BONECP = "com.jolbox.bonecp:type=BoneCP";
    private static final String[] METADATATABLE = new String[]{"TABLE"};
    private static final String KEEPALIVEMETADATA = "BONECPKEEPALIVE";
    protected final int poolAvailabilityThreshold;
    protected int partitionCount;
    protected ConnectionPartition[] partitions;
    @VisibleForTesting
    protected ScheduledExecutorService keepAliveScheduler;
    private ScheduledExecutorService maxAliveScheduler;
    private ExecutorService connectionsScheduler;
    @VisibleForTesting
    protected BoneCPConfig config;
    private ListeningExecutorService asyncExecutor;
    private static final Logger logger = LoggerFactory.getLogger(BoneCP.class);
    private MBeanServer mbs;
    protected boolean closeConnectionWatch = false;
    private ExecutorService closeConnectionExecutor;
    protected volatile boolean poolShuttingDown;
    protected String shutdownStackTrace;
    private final Map<Connection, Reference<ConnectionHandle>> finalizableRefs = new ConcurrentHashMap<Connection, Reference<ConnectionHandle>>();
    private transient FinalizableReferenceQueue finalizableRefQueue;
    protected long connectionTimeoutInMs;
    private long closeConnectionWatchTimeoutInMs;
    protected boolean statisticsEnabled;
    protected Statistics statistics = new Statistics(this);
    @VisibleForTesting
    protected boolean nullOnConnectionTimeout;
    @VisibleForTesting
    protected boolean resetConnectionOnClose;
    protected boolean cachedPoolStrategy;
    protected ConnectionStrategy connectionStrategy;
    private AtomicBoolean dbIsDown = new AtomicBoolean();
    @VisibleForTesting
    protected Properties clientInfo;
    @VisibleForTesting
    protected volatile boolean driverInitialized = false;
    protected int jvmMajorVersion;
    protected static String connectionClass = "java.sql.Connection";

    public synchronized void shutdown() {
        if (!this.poolShuttingDown) {
            logger.info("Shutting down connection pool...");
            this.poolShuttingDown = true;
            this.shutdownStackTrace = this.captureStackTrace(SHUTDOWN_LOCATION_TRACE);
            this.keepAliveScheduler.shutdownNow();
            this.maxAliveScheduler.shutdownNow();
            this.connectionsScheduler.shutdownNow();
            this.asyncExecutor.shutdownNow();
            try {
                this.connectionsScheduler.awaitTermination(5L, TimeUnit.SECONDS);
                this.maxAliveScheduler.awaitTermination(5L, TimeUnit.SECONDS);
                this.keepAliveScheduler.awaitTermination(5L, TimeUnit.SECONDS);
                this.asyncExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                if (this.closeConnectionExecutor != null) {
                    this.closeConnectionExecutor.shutdownNow();
                    this.closeConnectionExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.connectionStrategy.terminateAllConnections();
            this.unregisterDriver();
            this.registerUnregisterJMX(false);
            if (this.finalizableRefQueue != null) {
                this.finalizableRefQueue.close();
            }
            logger.info("Connection pool has been shutdown.");
        }
    }

    protected void unregisterDriver() {
        String jdbcURL = this.config.getJdbcUrl();
        if (jdbcURL != null && this.config.isDeregisterDriverOnClose()) {
            logger.info("Unregistering JDBC driver for : " + jdbcURL);
            try {
                DriverManager.deregisterDriver(DriverManager.getDriver(jdbcURL));
            }
            catch (SQLException e) {
                logger.info("Unregistering driver failed.", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    protected void destroyConnection(ConnectionHandle conn) {
        this.postDestroyConnection(conn);
        conn.setInReplayMode(true);
        try {
            conn.internalClose();
        }
        catch (SQLException e) {
            logger.error("Error in attempting to close connection", (Throwable)e);
        }
    }

    protected void postDestroyConnection(ConnectionHandle handle) {
        ConnectionPartition partition = handle.getOriginatingPartition();
        if (this.finalizableRefQueue != null && handle.getInternalConnection() != null) {
            this.finalizableRefs.remove(handle.getInternalConnection());
        }
        partition.updateCreatedConnections(-1);
        partition.setUnableToCreateMoreTransactions(false);
        if (handle.getConnectionHook() != null) {
            handle.getConnectionHook().onDestroy(handle);
        }
    }

    protected Connection obtainInternalConnection(ConnectionHandle connectionHandle) throws SQLException {
        boolean tryAgain = false;
        Connection result = null;
        Connection oldRawConnection = connectionHandle.getInternalConnection();
        String url = this.getConfig().getJdbcUrl();
        int acquireRetryAttempts = this.getConfig().getAcquireRetryAttempts();
        long acquireRetryDelayInMs = this.getConfig().getAcquireRetryDelayInMs();
        AcquireFailConfig acquireConfig = new AcquireFailConfig();
        acquireConfig.setAcquireRetryAttempts(new AtomicInteger(acquireRetryAttempts));
        acquireConfig.setAcquireRetryDelayInMs(acquireRetryDelayInMs);
        acquireConfig.setLogMessage("Failed to acquire connection to " + url);
        ConnectionHook connectionHook = this.getConfig().getConnectionHook();
        do {
            result = null;
            try {
                result = this.obtainRawInternalConnection();
                tryAgain = false;
                if (acquireRetryAttempts != this.getConfig().getAcquireRetryAttempts()) {
                    logger.info("Successfully re-established connection to " + url);
                }
                this.getDbIsDown().set(false);
                connectionHandle.setInternalConnection(result);
                if (connectionHook != null) {
                    connectionHook.onAcquire(connectionHandle);
                }
                ConnectionHandle.sendInitSQL(result, this.getConfig().getInitSQL());
            }
            catch (SQLException e) {
                if (connectionHook != null) {
                    tryAgain = connectionHook.onAcquireFail(e, acquireConfig);
                } else {
                    logger.error(String.format("Failed to acquire connection to %s. Sleeping for %d ms. Attempts left: %d", url, acquireRetryDelayInMs, acquireRetryAttempts), (Throwable)e);
                    try {
                        if (acquireRetryAttempts > 0) {
                            Thread.sleep(acquireRetryDelayInMs);
                        }
                        tryAgain = acquireRetryAttempts-- > 0;
                    }
                    catch (InterruptedException e1) {
                        tryAgain = false;
                    }
                }
                if (tryAgain) continue;
                if (oldRawConnection != null) {
                    oldRawConnection.close();
                }
                if (result != null) {
                    result.close();
                }
                connectionHandle.setInternalConnection(oldRawConnection);
                throw e;
            }
        } while (tryAgain);
        return result;
    }

    protected Connection obtainRawInternalConnection() throws SQLException {
        Connection result = null;
        DataSource datasourceBean = this.config.getDatasourceBean();
        String url = this.config.getJdbcUrl();
        String username = this.config.getUsername();
        String password = this.config.getPassword();
        Properties props = this.config.getDriverProperties();
        boolean externalAuth = this.config.isExternalAuth();
        if (externalAuth && props == null) {
            props = new Properties();
        }
        if (datasourceBean != null) {
            return username == null ? datasourceBean.getConnection() : datasourceBean.getConnection(username, password);
        }
        if (!this.driverInitialized) {
            try {
                this.driverInitialized = true;
                result = props != null ? DriverManager.getConnection(url, props) : DriverManager.getConnection(url, username, password);
                result.close();
            }
            catch (SQLException t) {
                // empty catch block
            }
        }
        result = props != null ? DriverManager.getConnection(url, props) : DriverManager.getConnection(url, username, password);
        if (this.clientInfo != null) {
            result.setClientInfo(this.clientInfo);
        }
        return result;
    }

    public BoneCP(BoneCPConfig config) throws SQLException {
        boolean queueLIFO;
        try {
            this.jvmMajorVersion = 5;
            Class<?> clazz = Class.forName(connectionClass, true, config.getClassLoader());
            clazz.getMethod("createClob", new Class[0]);
            this.jvmMajorVersion = 6;
            clazz.getMethod("getNetworkTimeout", new Class[0]);
            this.jvmMajorVersion = 7;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.config = ((BoneCPConfig)Preconditions.checkNotNull((Object)config)).clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new SQLException("Cloning of the config failed");
        }
        this.config.sanitize();
        this.statisticsEnabled = config.isStatisticsEnabled();
        this.closeConnectionWatchTimeoutInMs = config.getCloseConnectionWatchTimeoutInMs();
        this.poolAvailabilityThreshold = config.getPoolAvailabilityThreshold();
        this.connectionTimeoutInMs = config.getConnectionTimeoutInMs();
        if (this.connectionTimeoutInMs == 0L) {
            this.connectionTimeoutInMs = Long.MAX_VALUE;
        }
        this.nullOnConnectionTimeout = config.isNullOnConnectionTimeout();
        this.resetConnectionOnClose = config.isResetConnectionOnClose();
        this.clientInfo = this.jvmMajorVersion > 5 ? config.getClientInfo() : null;
        AcquireFailConfig acquireConfig = new AcquireFailConfig();
        acquireConfig.setAcquireRetryAttempts(new AtomicInteger(0));
        acquireConfig.setAcquireRetryDelayInMs(0L);
        acquireConfig.setLogMessage("Failed to obtain initial connection");
        if (!config.isLazyInit()) {
            try {
                Connection sanityConnection = this.obtainRawInternalConnection();
                sanityConnection.close();
            }
            catch (Exception e) {
                if (config.getConnectionHook() != null) {
                    config.getConnectionHook().onAcquireFail(e, acquireConfig);
                }
                throw PoolUtil.generateSQLException(String.format(ERROR_TEST_CONNECTION, config.getJdbcUrl(), config.getUsername(), PoolUtil.stringifyException(e)), e);
            }
        }
        if (!config.isDisableConnectionTracking()) {
            this.finalizableRefQueue = new FinalizableReferenceQueue();
        }
        this.asyncExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.config = config;
        this.partitions = new ConnectionPartition[config.getPartitionCount()];
        String suffix = "";
        if (config.getPoolName() != null) {
            suffix = "-" + config.getPoolName();
        }
        this.keepAliveScheduler = Executors.newScheduledThreadPool(config.getPartitionCount(), new CustomThreadFactory("BoneCP-keep-alive-scheduler" + suffix, true));
        this.maxAliveScheduler = Executors.newScheduledThreadPool(config.getPartitionCount(), new CustomThreadFactory("BoneCP-max-alive-scheduler" + suffix, true));
        this.connectionsScheduler = Executors.newFixedThreadPool(config.getPartitionCount(), new CustomThreadFactory("BoneCP-pool-watch-thread" + suffix, true));
        this.partitionCount = config.getPartitionCount();
        this.closeConnectionWatch = config.isCloseConnectionWatch();
        this.cachedPoolStrategy = config.getPoolStrategy() != null && config.getPoolStrategy().equalsIgnoreCase("CACHED");
        this.connectionStrategy = this.cachedPoolStrategy ? new CachedConnectionStrategy(this, new DefaultConnectionStrategy(this)) : new DefaultConnectionStrategy(this);
        boolean bl = queueLIFO = config.getServiceOrder() != null && config.getServiceOrder().equalsIgnoreCase("LIFO");
        if (this.closeConnectionWatch) {
            logger.warn(THREAD_CLOSE_CONNECTION_WARNING);
            this.closeConnectionExecutor = Executors.newCachedThreadPool(new CustomThreadFactory("BoneCP-connection-watch-thread" + suffix, true));
        }
        for (int p = 0; p < config.getPartitionCount(); ++p) {
            ConnectionPartition connectionPartition;
            this.partitions[p] = connectionPartition = new ConnectionPartition(this);
            LinkedBlockingQueue<ConnectionHandle> connectionHandles = new LinkedBlockingQueue<ConnectionHandle>(this.config.getMaxConnectionsPerPartition());
            this.partitions[p].setFreeConnections(connectionHandles);
            if (!config.isLazyInit()) {
                for (int i = 0; i < config.getMinConnectionsPerPartition(); ++i) {
                    this.partitions[p].addFreeConnection(new ConnectionHandle(null, this.partitions[p], this, false));
                }
            }
            if (config.getIdleConnectionTestPeriod(TimeUnit.SECONDS) > 0L || config.getIdleMaxAge(TimeUnit.SECONDS) > 0L) {
                ConnectionTesterThread connectionTester = new ConnectionTesterThread(connectionPartition, this.keepAliveScheduler, this, config.getIdleMaxAge(TimeUnit.MILLISECONDS), config.getIdleConnectionTestPeriod(TimeUnit.MILLISECONDS), queueLIFO);
                long delayInSeconds = config.getIdleConnectionTestPeriod(TimeUnit.SECONDS);
                if (delayInSeconds == 0L) {
                    delayInSeconds = config.getIdleMaxAge(TimeUnit.SECONDS);
                }
                if (config.getIdleMaxAge(TimeUnit.SECONDS) < delayInSeconds && config.getIdleConnectionTestPeriod(TimeUnit.SECONDS) != 0L && config.getIdleMaxAge(TimeUnit.SECONDS) != 0L) {
                    delayInSeconds = config.getIdleMaxAge(TimeUnit.SECONDS);
                }
                this.keepAliveScheduler.schedule(connectionTester, delayInSeconds, TimeUnit.SECONDS);
            }
            if (config.getMaxConnectionAgeInSeconds() > 0L) {
                ConnectionMaxAgeThread connectionMaxAgeTester = new ConnectionMaxAgeThread(connectionPartition, this.maxAliveScheduler, this, config.getMaxConnectionAge(TimeUnit.MILLISECONDS), queueLIFO);
                this.maxAliveScheduler.schedule(connectionMaxAgeTester, config.getMaxConnectionAgeInSeconds(), TimeUnit.SECONDS);
            }
            this.connectionsScheduler.execute(new PoolWatchThread(connectionPartition, this));
        }
        if (!this.config.isDisableJMX()) {
            this.registerUnregisterJMX(true);
        }
    }

    protected void registerUnregisterJMX(boolean doRegister) {
        if (this.mbs == null) {
            this.mbs = ManagementFactory.getPlatformMBeanServer();
        }
        try {
            String suffix = "";
            if (this.config.getPoolName() != null) {
                suffix = "-" + this.config.getPoolName();
            }
            ObjectName name = new ObjectName(MBEAN_BONECP + suffix);
            ObjectName configname = new ObjectName(MBEAN_CONFIG + suffix);
            if (doRegister) {
                if (!this.mbs.isRegistered(name)) {
                    this.mbs.registerMBean(this.statistics, name);
                }
                if (!this.mbs.isRegistered(configname)) {
                    this.mbs.registerMBean(this.config, configname);
                }
            } else {
                if (this.mbs.isRegistered(name)) {
                    this.mbs.unregisterMBean(name);
                }
                if (this.mbs.isRegistered(configname)) {
                    this.mbs.unregisterMBean(configname);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to start/stop JMX", (Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connectionStrategy.getConnection();
    }

    protected void watchConnection(ConnectionHandle connectionHandle) {
        String message = this.captureStackTrace(UNCLOSED_EXCEPTION_MESSAGE);
        this.closeConnectionExecutor.submit(new CloseThreadMonitor(Thread.currentThread(), connectionHandle, message, this.closeConnectionWatchTimeoutInMs));
    }

    protected String captureStackTrace(String message) {
        StringBuilder stringBuilder = new StringBuilder(String.format(message, Thread.currentThread().getName()));
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            stringBuilder.append(" " + trace[i] + "\r\n");
        }
        stringBuilder.append("");
        return stringBuilder.toString();
    }

    public ListenableFuture<Connection> getAsyncConnection() {
        return this.asyncExecutor.submit((Callable)new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return BoneCP.this.getConnection();
            }
        });
    }

    protected void maybeSignalForMoreConnections(ConnectionPartition connectionPartition) {
        if (!connectionPartition.isUnableToCreateMoreTransactions() && !this.poolShuttingDown && connectionPartition.getAvailableConnections() * 100 / connectionPartition.getMaxConnections() <= this.poolAvailabilityThreshold) {
            connectionPartition.getPoolWatchThreadSignalQueue().offer(new Object());
        }
    }

    protected void releaseConnection(Connection connection) throws SQLException {
        ConnectionHandle handle = (ConnectionHandle)connection;
        if (handle.getConnectionHook() != null) {
            handle.getConnectionHook().onCheckIn(handle);
        }
        if (!this.poolShuttingDown) {
            this.internalReleaseConnection(handle);
        }
    }

    protected void internalReleaseConnection(ConnectionHandle connectionHandle) throws SQLException {
        if (!this.cachedPoolStrategy) {
            connectionHandle.clearStatementCaches(false);
        }
        if (connectionHandle.getReplayLog() != null) {
            connectionHandle.getReplayLog().clear();
            connectionHandle.recoveryResult.getReplaceTarget().clear();
        }
        if (connectionHandle.isExpired() || !this.poolShuttingDown && connectionHandle.isPossiblyBroken() && !this.isConnectionHandleAlive(connectionHandle)) {
            if (connectionHandle.isExpired()) {
                connectionHandle.internalClose();
            }
            ConnectionPartition connectionPartition = connectionHandle.getOriginatingPartition();
            this.postDestroyConnection(connectionHandle);
            this.maybeSignalForMoreConnections(connectionPartition);
            connectionHandle.clearStatementCaches(true);
            return;
        }
        connectionHandle.setConnectionLastUsedInMs(System.currentTimeMillis());
        if (!this.poolShuttingDown) {
            this.putConnectionBackInPartition(connectionHandle);
        } else {
            connectionHandle.internalClose();
        }
    }

    protected void putConnectionBackInPartition(ConnectionHandle connectionHandle) throws SQLException {
        if (this.cachedPoolStrategy && ((CachedConnectionStrategy)this.connectionStrategy).tlConnections.dumbGet().getValue().booleanValue()) {
            connectionHandle.logicallyClosed.set(true);
            ((CachedConnectionStrategy)this.connectionStrategy).tlConnections.set(new AbstractMap.SimpleEntry<ConnectionHandle, Boolean>(connectionHandle, false));
        } else {
            BlockingQueue<ConnectionHandle> queue = connectionHandle.getOriginatingPartition().getFreeConnections();
            if (!queue.offer(connectionHandle)) {
                connectionHandle.internalClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionHandleAlive(ConnectionHandle connection) {
        Statement stmt = null;
        boolean result = false;
        boolean logicallyClosed = connection.logicallyClosed.get();
        try {
            connection.logicallyClosed.compareAndSet(true, false);
            String testStatement = this.config.getConnectionTestStatement();
            ResultSet rs = null;
            if (testStatement == null) {
                rs = connection.getMetaData().getTables(null, null, KEEPALIVEMETADATA, METADATATABLE);
            } else {
                stmt = connection.createStatement();
                stmt.execute(testStatement);
            }
            if (rs != null) {
                rs.close();
            }
            result = true;
            connection.logicallyClosed.set(logicallyClosed);
            connection.setConnectionLastResetInMs(System.currentTimeMillis());
            result = this.closeStatement(stmt, result);
        }
        catch (SQLException e) {
            result = false;
        }
        finally {
            connection.logicallyClosed.set(logicallyClosed);
            connection.setConnectionLastResetInMs(System.currentTimeMillis());
            result = this.closeStatement(stmt, result);
        }
        return result;
    }

    private boolean closeStatement(Statement stmt, boolean result) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                return false;
            }
        }
        return result;
    }

    public int getTotalLeased() {
        int total = 0;
        for (int i = 0; i < this.partitionCount && this.partitions[i] != null; ++i) {
            total += this.partitions[i].getCreatedConnections() - this.partitions[i].getAvailableConnections();
        }
        return total;
    }

    public int getTotalFree() {
        int total = 0;
        for (int i = 0; i < this.partitionCount && this.partitions[i] != null; ++i) {
            total += this.partitions[i].getAvailableConnections();
        }
        return total;
    }

    public int getTotalCreatedConnections() {
        int total = 0;
        for (int i = 0; i < this.partitionCount && this.partitions[i] != null; ++i) {
            total += this.partitions[i].getCreatedConnections();
        }
        return total;
    }

    public BoneCPConfig getConfig() {
        return this.config;
    }

    protected Map<Connection, Reference<ConnectionHandle>> getFinalizableRefs() {
        return this.finalizableRefs;
    }

    protected FinalizableReferenceQueue getFinalizableRefQueue() {
        return this.finalizableRefQueue;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public AtomicBoolean getDbIsDown() {
        return this.dbIsDown;
    }
}

