/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.rest.ExponentialHttpRetryInterceptor;
import org.apache.paimon.rest.RESTApi;
import org.apache.paimon.rest.auth.DLFToken;
import org.apache.paimon.rest.auth.DLFTokenLoader;
import org.apache.paimon.shade.okhttp3.ConnectionSpec;
import org.apache.paimon.shade.okhttp3.OkHttpClient;
import org.apache.paimon.shade.okhttp3.Request;
import org.apache.paimon.shade.okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLFECSTokenLoader
implements DLFTokenLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DLFECSTokenLoader.class);
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT)).addInterceptor(new ExponentialHttpRetryInterceptor(3)).connectTimeout(Duration.ofMinutes(3L)).readTimeout(Duration.ofMinutes(3L)).build();
    private final String ecsMetadataURL;
    private String roleName;

    public DLFECSTokenLoader(String ecsMetaDataURL, @Nullable String roleName) {
        this.ecsMetadataURL = ecsMetaDataURL;
        this.roleName = roleName;
    }

    @Override
    public DLFToken loadToken() {
        if (this.roleName == null) {
            this.roleName = DLFECSTokenLoader.getRole(this.ecsMetadataURL);
        }
        return DLFECSTokenLoader.getToken(this.ecsMetadataURL + this.roleName);
    }

    @Override
    public String description() {
        return this.ecsMetadataURL;
    }

    private static String getRole(String url) {
        try {
            return DLFECSTokenLoader.getResponseBody(url);
        }
        catch (Exception e) {
            throw new RuntimeException("get role failed, error : " + e.getMessage(), e);
        }
    }

    private static DLFToken getToken(String url) {
        try {
            String token = DLFECSTokenLoader.getResponseBody(url);
            return RESTApi.fromJson(token, DLFToken.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException("get token failed, error : " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected static String getResponseBody(String url) {
        Request request = new Request.Builder().url(url).get().build();
        long startTime = System.currentTimeMillis();
        try (Response response = HTTP_CLIENT.newCall(request).execute();){
            String responseBodyStr;
            if (response == null) {
                throw new RuntimeException("get response failed, response is null");
            }
            if (!response.isSuccessful()) {
                throw new RuntimeException("get response failed, response : " + response);
            }
            String string = responseBodyStr = response.body() != null ? response.body().string() : null;
            if (responseBodyStr == null) {
                throw new RuntimeException("get response failed, response body is null");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("get response success, url : {}, cost : {} ms", (Object)url, (Object)(System.currentTimeMillis() - startTime));
            }
            String string2 = responseBodyStr;
            return string2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("get response failed, error : " + e.getMessage(), e);
        }
    }
}

