/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.meta.StatisticEntity;
import org.apache.gravitino.storage.relational.mapper.StatisticMetaMapper;
import org.apache.gravitino.storage.relational.po.StatisticPO;
import org.apache.gravitino.storage.relational.service.MetadataObjectService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class StatisticMetaService {
    private static final StatisticMetaService INSTANCE = new StatisticMetaService();

    public static StatisticMetaService getInstance() {
        return INSTANCE;
    }

    private StatisticMetaService() {
    }

    public List<StatisticEntity> listStatisticsByEntity(NameIdentifier identifier, Entity.EntityType type) {
        long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(NameIdentifierUtil.getMetalake(identifier));
        MetadataObject object = NameIdentifierUtil.toMetadataObject(identifier, type);
        long entityId = MetadataObjectService.getMetadataObjectId(metalakeId, object.fullName(), object.type());
        List statisticPOs = SessionUtils.getWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.listStatisticPOsByEntityId(metalakeId, entityId));
        return statisticPOs.stream().map(StatisticPO::fromStatisticPO).collect(Collectors.toList());
    }

    public void batchInsertStatisticPOsOnDuplicateKeyUpdate(List<StatisticEntity> statisticEntities, NameIdentifier entity, Entity.EntityType type) {
        if (statisticEntities == null || statisticEntities.isEmpty()) {
            return;
        }
        String metalake = NameIdentifierUtil.getMetalake(entity);
        Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalake);
        MetadataObject object = NameIdentifierUtil.toMetadataObject(entity, type);
        Long entityId = MetadataObjectService.getMetadataObjectId(metalakeId, object.fullName(), object.type());
        List<StatisticPO> pos = StatisticPO.initializeStatisticPOs(statisticEntities, metalakeId, entityId, object.type());
        SessionUtils.doWithCommit(StatisticMetaMapper.class, mapper -> mapper.batchInsertStatisticPOsOnDuplicateKeyUpdate(pos));
    }

    public int batchDeleteStatisticPOs(NameIdentifier identifier, Entity.EntityType type, List<String> statisticNames) {
        if (statisticNames == null || statisticNames.isEmpty()) {
            return 0;
        }
        Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(NameIdentifierUtil.getMetalake(identifier));
        MetadataObject object = NameIdentifierUtil.toMetadataObject(identifier, type);
        Long entityId = MetadataObjectService.getMetadataObjectId(metalakeId, object.fullName(), object.type());
        return SessionUtils.doWithCommitAndFetchResult(StatisticMetaMapper.class, mapper -> mapper.batchDeleteStatisticPOs(entityId, statisticNames));
    }

    public int deleteStatisticsByLegacyTimeline(long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(StatisticMetaMapper.class, mapper -> mapper.deleteStatisticsByLegacyTimeline(legacyTimeline, limit));
    }
}

