/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;

public class SecurableObjects {
    public static final Splitter DOT_SPLITTER = Splitter.on((char)'.');

    public static SecurableObject ofMetalake(String metalake, List<Privilege> privileges) {
        return SecurableObjects.of(MetadataObject.Type.METALAKE, Lists.newArrayList((Object[])new String[]{metalake}), privileges);
    }

    public static SecurableObject ofCatalog(String catalog, List<Privilege> privileges) {
        return SecurableObjects.of(MetadataObject.Type.CATALOG, Lists.newArrayList((Object[])new String[]{catalog}), privileges);
    }

    public static SecurableObject ofSchema(SecurableObject catalog, String schema, List<Privilege> privileges) {
        return SecurableObjects.of(MetadataObject.Type.SCHEMA, Lists.newArrayList((Object[])new String[]{catalog.fullName(), schema}), privileges);
    }

    public static SecurableObject ofTable(SecurableObject schema, String table, List<Privilege> privileges) {
        ArrayList names = Lists.newArrayList((Iterable)DOT_SPLITTER.splitToList((CharSequence)schema.fullName()));
        names.add(table);
        return SecurableObjects.of(MetadataObject.Type.TABLE, names, privileges);
    }

    public static SecurableObject ofTopic(SecurableObject schema, String topic, List<Privilege> privileges) {
        ArrayList names = Lists.newArrayList((Iterable)DOT_SPLITTER.splitToList((CharSequence)schema.fullName()));
        names.add(topic);
        return SecurableObjects.of(MetadataObject.Type.TOPIC, names, privileges);
    }

    public static SecurableObject ofFileset(SecurableObject schema, String fileset, List<Privilege> privileges) {
        ArrayList names = Lists.newArrayList((Iterable)DOT_SPLITTER.splitToList((CharSequence)schema.fullName()));
        names.add(fileset);
        return SecurableObjects.of(MetadataObject.Type.FILESET, names, privileges);
    }

    public static SecurableObject ofModel(SecurableObject schema, String model, List<Privilege> privileges) {
        ArrayList names = Lists.newArrayList((Iterable)DOT_SPLITTER.splitToList((CharSequence)schema.fullName()));
        names.add(model);
        return SecurableObjects.of(MetadataObject.Type.MODEL, names, privileges);
    }

    public static SecurableObject parse(String fullName, MetadataObject.Type type, List<Privilege> privileges) {
        MetadataObject metadataObject = MetadataObjects.parse(fullName, type);
        return new SecurableObjectImpl(metadataObject.parent(), metadataObject.name(), type, privileges);
    }

    static SecurableObject of(MetadataObject.Type type, List<String> names, List<Privilege> privileges) {
        MetadataObject metadataObject = MetadataObjects.of(names, type);
        return new SecurableObjectImpl(metadataObject.parent(), metadataObject.name(), type, privileges);
    }

    private static class SecurableObjectImpl
    extends MetadataObjects.MetadataObjectImpl
    implements SecurableObject {
        private List<Privilege> privileges;

        SecurableObjectImpl(String parent, String name, MetadataObject.Type type, List<Privilege> privileges) {
            super(parent, name, type);
            this.privileges = ImmutableList.copyOf((Collection)Sets.newHashSet(privileges));
        }

        @Override
        public List<Privilege> privileges() {
            return this.privileges;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return Objects.hash(result, this.privileges);
        }

        @Override
        public String toString() {
            String privilegesStr = this.privileges.stream().map(p -> "[" + p.simpleString() + "]").collect(Collectors.joining(","));
            return "SecurableObject: [fullName=" + this.fullName() + "], [type=" + String.valueOf((Object)this.type()) + "], [privileges=" + privilegesStr + "]";
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SecurableObject)) {
                return false;
            }
            SecurableObject otherSecurableObject = (SecurableObject)other;
            return super.equals(other) && this.isEqualCollection(this.privileges, otherSecurableObject.privileges());
        }

        private boolean isEqualCollection(Collection<?> c1, Collection<?> c2) {
            if (c1 == c2) {
                return true;
            }
            if (c1 == null || c2 == null) {
                return false;
            }
            return CollectionUtils.isEqualCollection(c1, c2);
        }
    }
}

