/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.policy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.policy.PolicyContentDTO;
import org.apache.gravitino.policy.Policy;

public class PolicyDTO
implements Policy {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="policyType")
    private String policyType;
    @JsonProperty(value="enabled")
    private boolean enabled;
    @JsonProperty(value="content")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="policyType", defaultImpl=PolicyContentDTO.CustomContentDTO.class)
    @JsonSubTypes(value={})
    private PolicyContentDTO content;
    @JsonProperty(value="inherited")
    private Optional<Boolean> inherited = Optional.empty();
    @JsonProperty(value="audit")
    private AuditDTO audit;

    private PolicyDTO() {
    }

    public boolean equals(Object o) {
        if (!(o instanceof PolicyDTO)) {
            return false;
        }
        PolicyDTO policyDTO = (PolicyDTO)o;
        return this.enabled == policyDTO.enabled && Objects.equals(this.name, policyDTO.name) && Objects.equals(this.comment, policyDTO.comment) && Objects.equals(this.policyType, policyDTO.policyType) && Objects.equals(this.content, policyDTO.content) && Objects.equals(this.audit, policyDTO.audit);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comment, this.policyType, this.enabled, this.content, this.audit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public String policyType() {
        return this.policyType;
    }

    public String comment() {
        return this.comment;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public PolicyContentDTO content() {
        return this.content;
    }

    public Optional<Boolean> inherited() {
        return this.inherited;
    }

    public AuditDTO auditInfo() {
        return this.audit;
    }

    public String toString() {
        return "PolicyDTO(name=" + this.name + ", comment=" + this.comment + ", policyType=" + this.policyType + ", enabled=" + this.enabled + ", content=" + String.valueOf(this.content) + ", inherited=" + String.valueOf(this.inherited) + ", audit=" + String.valueOf(this.audit) + ")";
    }

    public static class Builder {
        private final PolicyDTO policyDTO = new PolicyDTO();

        private Builder() {
        }

        public Builder withName(String name) {
            this.policyDTO.name = name;
            return this;
        }

        public Builder withComment(String comment) {
            this.policyDTO.comment = comment;
            return this;
        }

        public Builder withPolicyType(String policyType) {
            this.policyDTO.policyType = policyType;
            return this;
        }

        public Builder withEnabled(boolean enabled) {
            this.policyDTO.enabled = enabled;
            return this;
        }

        public Builder withContent(PolicyContentDTO content) {
            this.policyDTO.content = content;
            return this;
        }

        public Builder withAudit(AuditDTO audit) {
            this.policyDTO.audit = audit;
            return this;
        }

        public Builder withInherited(Optional<Boolean> inherited) {
            this.policyDTO.inherited = inherited;
            return this;
        }

        public PolicyDTO build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.policyDTO.name), (Object)"policy name cannot be empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.policyDTO.policyType), (Object)"policy type cannot be empty");
            Preconditions.checkArgument((this.policyDTO.content != null ? 1 : 0) != 0, (Object)"policy content cannot be null");
            this.policyDTO.content.validate();
            return this.policyDTO;
        }
    }
}

