/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.PolicyVersionBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.PolicyVersionPO;

public class PolicyVersionPostgreSQLProvider
extends PolicyVersionBaseSQLProvider {
    @Override
    public String softDeletePolicyVersionByMetalakeAndPolicyName(String metalakeName, String policyName) {
        return "UPDATE policy_version_info SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE metalake_id = (SELECT metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND policy_id = (SELECT policy_id FROM policy_meta pm WHERE pm.policy_name = #{policyName} AND pm.deleted_at = 0) AND deleted_at = 0";
    }

    @Override
    public String deletePolicyVersionsByLegacyTimeline(Long legacyTimeline, int limit) {
        return "DELETE FROM policy_version_info WHERE id IN (SELECT id FROM policy_version_info WHERE deleted_at = 0 AND legacy_timeline < #{legacyTimeline} LIMIT #{limit})";
    }

    @Override
    public String softDeletePolicyVersionsByRetentionLine(Long policyId, long versionRetentionLine, int limit) {
        return "UPDATE policy_version_info SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE id IN (SELECT id FROM policy_version_info WHERE policy_id = #{policyId} AND version < #{versionRetentionLine} AND deleted_at = 0 LIMIT #{limit})";
    }

    @Override
    public String softDeletePolicyVersionsByMetalakeId(Long metalakeId) {
        return "UPDATE policy_version_info SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String insertPolicyVersionOnDuplicateKeyUpdate(PolicyVersionPO policyVersion) {
        return "INSERT INTO policy_version_info (metalake_id, policy_id, version, policy_comment, enabled, content, deleted_at) VALUES ( #{policyVersion.metalakeId}, #{policyVersion.policyId}, #{policyVersion.version}, #{policyVersion.policyComment}, #{policyVersion.enabled}, #{policyVersion.content}, #{policyVersion.deletedAt}) ON CONFLICT (policy_id, version, deleted_at) DO UPDATE SET policy_comment = #{policyVersion.policyComment}, enabled = #{policyVersion.enabled}, content = #{policyVersion.content}, deleted_at = #{policyVersion.deletedAt}";
    }
}

