/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.JobTemplateMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.JobTemplateMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.JobTemplatePO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class JobTemplateMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, JobTemplateMetaBaseSQLProvider> JOB_TEMPLATE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new JobTemplateMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new JobTemplateMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new JobTemplateMetaPostgreSQLProvider());

    public static JobTemplateMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return JOB_TEMPLATE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertJobTemplateMeta(@Param(value="jobTemplateMeta") JobTemplatePO jobTemplatePO) {
        return JobTemplateMetaSQLProviderFactory.getProvider().insertJobTemplateMeta(jobTemplatePO);
    }

    public static String insertJobTemplateMetaOnDuplicateKeyUpdate(@Param(value="jobTemplateMeta") JobTemplatePO jobTemplatePO) {
        return JobTemplateMetaSQLProviderFactory.getProvider().insertJobTemplateMetaOnDuplicateKeyUpdate(jobTemplatePO);
    }

    public static String listJobTemplatePOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return JobTemplateMetaSQLProviderFactory.getProvider().listJobTemplatePOsByMetalake(metalakeName);
    }

    public static String selectJobTemplatePOByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return JobTemplateMetaSQLProviderFactory.getProvider().selectJobTemplatePOByMetalakeAndName(metalakeName, jobTemplateName);
    }

    public static String softDeleteJobTemplateMetaByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return JobTemplateMetaSQLProviderFactory.getProvider().softDeleteJobTemplateMetaByMetalakeAndName(metalakeName, jobTemplateName);
    }

    public static String softDeleteJobTemplateMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return JobTemplateMetaSQLProviderFactory.getProvider().softDeleteJobTemplateMetasByMetalakeId(metalakeId);
    }

    public static String deleteJobTemplateMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return JobTemplateMetaSQLProviderFactory.getProvider().deleteJobTemplateMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class JobTemplateMetaMySQLProvider
    extends JobTemplateMetaBaseSQLProvider {
        JobTemplateMetaMySQLProvider() {
        }
    }

    static class JobTemplateMetaH2Provider
    extends JobTemplateMetaBaseSQLProvider {
        JobTemplateMetaH2Provider() {
        }
    }
}

