/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.function;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.function.Function;
import org.apache.paimon.function.FunctionDefinition;
import org.apache.paimon.types.DataField;

public class FunctionImpl
implements Function {
    private final Identifier identifier;
    private final List<DataField> inputParams;
    private final List<DataField> returnParams;
    private final boolean deterministic;
    private final Map<String, FunctionDefinition> definitions;
    private final String comment;
    private final Map<String, String> options;

    public FunctionImpl(Identifier identifier, List<DataField> inputParams, List<DataField> returnParams, boolean deterministic, Map<String, FunctionDefinition> definitions, String comment, Map<String, String> options) {
        this.identifier = identifier;
        this.inputParams = inputParams;
        this.returnParams = returnParams;
        this.deterministic = deterministic;
        this.definitions = definitions;
        this.comment = comment;
        this.options = options;
    }

    public FunctionImpl(Identifier identifier, Map<String, FunctionDefinition> definitions) {
        this.identifier = identifier;
        this.inputParams = null;
        this.returnParams = null;
        this.deterministic = true;
        this.definitions = definitions;
        this.comment = null;
        this.options = null;
    }

    @Override
    public String name() {
        return this.identifier.getObjectName();
    }

    @Override
    public String fullName() {
        return this.identifier.getFullName();
    }

    @Override
    public Optional<List<DataField>> inputParams() {
        return Optional.ofNullable(this.inputParams);
    }

    @Override
    public Optional<List<DataField>> returnParams() {
        return Optional.ofNullable(this.returnParams);
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public Map<String, FunctionDefinition> definitions() {
        return this.definitions;
    }

    @Override
    public FunctionDefinition definition(String name) {
        return this.definitions.get(name);
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }
}

