/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.utils;

import java.util.Arrays;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class TypeUtils {
    public static final int PRECISION_SECOND = 0;
    public static final int PRECISION_MICROSECOND = 6;

    private TypeUtils() {
    }

    public static Type fromPaimonType(DataType dataType) {
        return (Type)dataType.accept((DataTypeVisitor)PaimonToGravitinoTypeVisitor.INSTANCE);
    }

    public static DataType toPaimonType(Type type) {
        return GravitinoToPaimonTypeVisitor.visit(type);
    }

    private static class PaimonToGravitinoTypeVisitor
    extends DataTypeDefaultVisitor<Type> {
        private static final PaimonToGravitinoTypeVisitor INSTANCE = new PaimonToGravitinoTypeVisitor();

        private PaimonToGravitinoTypeVisitor() {
        }

        public Type visit(BooleanType booleanType) {
            return Types.BooleanType.get();
        }

        public Type visit(TinyIntType tinyIntType) {
            return Types.ByteType.get();
        }

        public Type visit(SmallIntType smallIntType) {
            return Types.ShortType.get();
        }

        public Type visit(IntType intType) {
            return Types.IntegerType.get();
        }

        public Type visit(BigIntType bigIntType) {
            return Types.LongType.get();
        }

        public Type visit(FloatType floatType) {
            return Types.FloatType.get();
        }

        public Type visit(DoubleType doubleType) {
            return Types.DoubleType.get();
        }

        public Type visit(DecimalType decimalType) {
            return Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        public Type visit(DateType dateType) {
            return Types.DateType.get();
        }

        public Type visit(TimeType timeType) {
            return Types.TimeType.of((int)timeType.getPrecision());
        }

        public Type visit(TimestampType timestampType) {
            return Types.TimestampType.withoutTimeZone((int)timestampType.getPrecision());
        }

        public Type visit(LocalZonedTimestampType localZonedTimestampType) {
            return Types.TimestampType.withTimeZone((int)localZonedTimestampType.getPrecision());
        }

        public Type visit(BinaryType binaryType) {
            return Types.FixedType.of((int)binaryType.getLength());
        }

        public Type visit(VarBinaryType varBinaryType) {
            return Types.BinaryType.get();
        }

        public Type visit(VarCharType varCharType) {
            if (varCharType.getLength() == Integer.MAX_VALUE) {
                return Types.StringType.get();
            }
            return Types.VarCharType.of((int)varCharType.getLength());
        }

        public Type visit(CharType charType) {
            return Types.FixedCharType.of((int)charType.getLength());
        }

        public Type visit(ArrayType arrayType) {
            return Types.ListType.of((Type)((Type)arrayType.getElementType().accept((DataTypeVisitor)this)), (boolean)arrayType.getElementType().isNullable());
        }

        public Type visit(MapType mapType) {
            return Types.MapType.of((Type)((Type)mapType.getKeyType().accept((DataTypeVisitor)this)), (Type)((Type)mapType.getValueType().accept((DataTypeVisitor)this)), (boolean)mapType.getValueType().isNullable());
        }

        public Type visit(RowType rowType) {
            return Types.StructType.of((Types.StructType.Field[])((Types.StructType.Field[])rowType.getFields().stream().map(field -> Types.StructType.Field.of((String)field.name(), (Type)((Type)field.type().accept((DataTypeVisitor)this)), (boolean)field.type().isNullable(), (String)field.description())).toArray(Types.StructType.Field[]::new)));
        }

        public Type visit(MultisetType multisetType) {
            return Types.MapType.of((Type)((Type)multisetType.getElementType().accept((DataTypeVisitor)this)), (Type)Types.IntegerType.get(), (boolean)false);
        }

        protected Type defaultMethod(DataType dataType) {
            return Types.UnparsedType.of((String)dataType.asSQLString());
        }
    }

    private static class GravitinoToPaimonTypeVisitor {
        private GravitinoToPaimonTypeVisitor() {
        }

        public static DataType visit(Type type) {
            switch (type.name()) {
                case BOOLEAN: {
                    return DataTypes.BOOLEAN();
                }
                case BYTE: {
                    return DataTypes.TINYINT();
                }
                case SHORT: {
                    return DataTypes.SMALLINT();
                }
                case INTEGER: {
                    return DataTypes.INT();
                }
                case LONG: {
                    return DataTypes.BIGINT();
                }
                case FLOAT: {
                    return DataTypes.FLOAT();
                }
                case DOUBLE: {
                    return DataTypes.DOUBLE();
                }
                case DECIMAL: {
                    Types.DecimalType decimalType = (Types.DecimalType)type;
                    return DataTypes.DECIMAL((int)decimalType.precision(), (int)decimalType.scale());
                }
                case DATE: {
                    return DataTypes.DATE();
                }
                case TIME: {
                    Types.TimeType timeType = (Types.TimeType)type;
                    int timeTypePrecision = timeType.hasPrecisionSet() ? timeType.precision() : 0;
                    return DataTypes.TIME((int)timeTypePrecision);
                }
                case TIMESTAMP: {
                    int timestampTypePrecision;
                    Types.TimestampType timestampType = (Types.TimestampType)type;
                    int n = timestampTypePrecision = timestampType.hasPrecisionSet() ? timestampType.precision() : 6;
                    if (timestampType.hasTimeZone()) {
                        return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)timestampTypePrecision);
                    }
                    return DataTypes.TIMESTAMP((int)timestampTypePrecision);
                }
                case STRING: {
                    return DataTypes.STRING();
                }
                case VARCHAR: {
                    return DataTypes.VARCHAR((int)((Types.VarCharType)type).length());
                }
                case FIXEDCHAR: {
                    return DataTypes.CHAR((int)((Types.FixedCharType)type).length());
                }
                case FIXED: {
                    Types.FixedType fixedType = (Types.FixedType)type;
                    return DataTypes.BINARY((int)fixedType.length());
                }
                case BINARY: {
                    return DataTypes.VARBINARY((int)Integer.MAX_VALUE);
                }
                case LIST: {
                    Types.ListType listType = (Types.ListType)type;
                    DataType elementType = GravitinoToPaimonTypeVisitor.visit(listType.elementType());
                    DataType elementTypeWithNullability = listType.elementNullable() ? elementType.nullable() : elementType.notNull();
                    return DataTypes.ARRAY((DataType)elementTypeWithNullability);
                }
                case MAP: {
                    Types.MapType mapType = (Types.MapType)type;
                    DataType keyType = GravitinoToPaimonTypeVisitor.visit(mapType.keyType());
                    DataType valueType = GravitinoToPaimonTypeVisitor.visit(mapType.valueType());
                    DataType valueTypeWithNullability = mapType.valueNullable() ? valueType.nullable() : valueType.notNull();
                    return DataTypes.MAP((DataType)keyType, (DataType)valueTypeWithNullability);
                }
                case STRUCT: {
                    RowType.Builder builder = RowType.builder();
                    Arrays.stream(((Types.StructType)type).fields()).forEach(field -> {
                        DataType dataType = GravitinoToPaimonTypeVisitor.visit(field.type());
                        DataType dataTypeWithNullable = field.nullable() ? dataType.nullable() : dataType.notNull();
                        builder.field(field.name(), dataTypeWithNullable, field.comment());
                    });
                    return builder.build();
                }
            }
            throw new UnsupportedOperationException(String.format("Paimon does not support Gravitino %s data type.", type.simpleString()));
        }
    }
}

