/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.mysql.converter;

import java.util.Optional;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class MysqlTypeConverter
extends JdbcTypeConverter {
    static final String BIT = "bit";
    static final String TINYINT = "tinyint";
    static final String TINYINT_UNSIGNED = "tinyint unsigned";
    static final String SMALLINT = "smallint";
    static final String SMALLINT_UNSIGNED = "smallint unsigned";
    static final String INT = "int";
    static final String INT_UNSIGNED = "int unsigned";
    static final String BIGINT = "bigint";
    static final String BIGINT_UNSIGNED = "bigint unsigned";
    static final String FLOAT = "float";
    static final String DOUBLE = "double";
    static final String DECIMAL = "decimal";
    static final String DECIMAL_UNSIGNED = "decimal unsigned";
    static final String CHAR = "char";
    static final String BINARY = "binary";
    static final String DATETIME = "datetime";

    public Type toGravitino(JdbcTypeConverter.JdbcTypeBean typeBean) {
        switch (typeBean.getTypeName().toLowerCase()) {
            case "bit": {
                if (typeBean.getColumnSize() == null || typeBean.getColumnSize() == 1) {
                    return Types.BooleanType.get();
                }
                return Types.BinaryType.get();
            }
            case "tinyint": {
                return Types.ByteType.get();
            }
            case "tinyint unsigned": {
                return Types.ByteType.unsigned();
            }
            case "smallint": {
                return Types.ShortType.get();
            }
            case "smallint unsigned": {
                return Types.ShortType.unsigned();
            }
            case "int": {
                return Types.IntegerType.get();
            }
            case "int unsigned": {
                return Types.IntegerType.unsigned();
            }
            case "bigint": {
                return Types.LongType.get();
            }
            case "bigint unsigned": {
                return Types.LongType.unsigned();
            }
            case "float": {
                return Types.FloatType.get();
            }
            case "double": {
                return Types.DoubleType.get();
            }
            case "date": {
                return Types.DateType.get();
            }
            case "time": {
                return (Type)Optional.ofNullable(typeBean.getDatetimePrecision()).map(Types.TimeType::of).orElseGet(Types.TimeType::get);
            }
            case "timestamp": {
                return (Type)Optional.ofNullable(typeBean.getDatetimePrecision()).map(Types.TimestampType::withTimeZone).orElseGet(Types.TimestampType::withTimeZone);
            }
            case "datetime": {
                return (Type)Optional.ofNullable(typeBean.getDatetimePrecision()).map(Types.TimestampType::withoutTimeZone).orElseGet(Types.TimestampType::withoutTimeZone);
            }
            case "decimal unsigned": 
            case "decimal": {
                return Types.DecimalType.of((int)typeBean.getColumnSize(), (int)typeBean.getScale());
            }
            case "varchar": {
                return Types.VarCharType.of((int)typeBean.getColumnSize());
            }
            case "char": {
                return Types.FixedCharType.of((int)typeBean.getColumnSize());
            }
            case "text": {
                return Types.StringType.get();
            }
            case "binary": {
                return Types.BinaryType.get();
            }
        }
        return Types.ExternalType.of((String)typeBean.getTypeName());
    }

    public String fromGravitino(Type type) {
        if (type instanceof Types.ByteType) {
            if (((Types.ByteType)type).signed()) {
                return TINYINT;
            }
            return TINYINT_UNSIGNED;
        }
        if (type instanceof Types.ShortType) {
            if (((Types.ShortType)type).signed()) {
                return SMALLINT;
            }
            return SMALLINT_UNSIGNED;
        }
        if (type instanceof Types.IntegerType) {
            if (((Types.IntegerType)type).signed()) {
                return INT;
            }
            return INT_UNSIGNED;
        }
        if (type instanceof Types.LongType) {
            if (((Types.LongType)type).signed()) {
                return BIGINT;
            }
            return BIGINT_UNSIGNED;
        }
        if (type instanceof Types.FloatType) {
            return type.simpleString();
        }
        if (type instanceof Types.DoubleType) {
            return type.simpleString();
        }
        if (type instanceof Types.StringType) {
            return "text";
        }
        if (type instanceof Types.DateType) {
            return type.simpleString();
        }
        if (type instanceof Types.TimeType) {
            return type.simpleString();
        }
        if (type instanceof Types.TimestampType) {
            Types.TimestampType timestampType = (Types.TimestampType)type;
            String baseType = timestampType.hasTimeZone() ? "timestamp" : DATETIME;
            return timestampType.hasPrecisionSet() ? String.format("%s(%d)", baseType, timestampType.precision()) : baseType;
        }
        if (type instanceof Types.DecimalType) {
            return type.simpleString();
        }
        if (type instanceof Types.VarCharType) {
            return type.simpleString();
        }
        if (type instanceof Types.FixedCharType) {
            return type.simpleString();
        }
        if (type instanceof Types.BinaryType) {
            return type.simpleString();
        }
        if (type instanceof Types.BooleanType) {
            return BIT;
        }
        if (type instanceof Types.ExternalType) {
            return ((Types.ExternalType)type).catalogString();
        }
        throw new IllegalArgumentException(String.format("Couldn't convert Gravitino type %s to MySQL type", type.simpleString()));
    }
}

