/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.hash;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.hash.HashContext;
import org.apache.paimon.lookup.hash.HashLookupStoreReader;
import org.apache.paimon.lookup.hash.HashLookupStoreWriter;
import org.apache.paimon.utils.BloomFilter;

public class HashLookupStoreFactory
implements LookupStoreFactory {
    private final CacheManager cacheManager;
    private final int cachePageSize;
    private final double loadFactor;
    @Nullable
    private final BlockCompressionFactory compressionFactory;

    public HashLookupStoreFactory(CacheManager cacheManager, int cachePageSize, double loadFactor, CompressOptions compression) {
        this.cacheManager = cacheManager;
        this.cachePageSize = cachePageSize;
        this.loadFactor = loadFactor;
        this.compressionFactory = BlockCompressionFactory.create(compression);
    }

    @Override
    public HashLookupStoreReader createReader(File file, LookupStoreFactory.Context context) throws IOException {
        return new HashLookupStoreReader(file, (HashContext)context, this.cacheManager, this.cachePageSize, this.compressionFactory);
    }

    @Override
    public HashLookupStoreWriter createWriter(File file, @Nullable BloomFilter.Builder bloomFilter) throws IOException {
        return new HashLookupStoreWriter(this.loadFactor, file, bloomFilter, this.compressionFactory, this.cachePageSize);
    }
}

