/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.common;

import org.apache.paimon.shade.org.apache.datasketches.common.Util;

public final class ByteArrayUtil {
    public static void copyBytes(byte[] source, int srcStart, byte[] target, int tgtStart, int numBytes) {
        Util.checkBounds(srcStart, numBytes, source.length);
        Util.checkBounds(tgtStart, numBytes, target.length);
        int j = srcStart;
        int k = tgtStart;
        for (int i = 0; i < numBytes; ++i) {
            target[k++] = source[j++];
        }
    }

    public static short getShortLE(byte[] array, int offset) {
        return (short)(array[offset] & 0xFF | (array[offset + 1] & 0xFF) << 8);
    }

    public static void putShortLE(byte[] array, int offset, short value) {
        array[offset] = (byte)value;
        array[offset + 1] = (byte)(value >>> 8);
    }

    public static short getShortBE(byte[] array, int offset) {
        return (short)(array[offset + 1] & 0xFF | (array[offset] & 0xFF) << 8);
    }

    public static void putShortBE(byte[] array, int offset, short value) {
        array[offset + 1] = (byte)value;
        array[offset] = (byte)(value >>> 8);
    }

    public static int getIntLE(byte[] array, int offset) {
        return array[offset] & 0xFF | (array[offset + 1] & 0xFF) << 8 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 3] & 0xFF) << 24;
    }

    public static void putIntLE(byte[] array, int offset, int value) {
        array[offset] = (byte)value;
        array[offset + 1] = (byte)(value >>> 8);
        array[offset + 2] = (byte)(value >>> 16);
        array[offset + 3] = (byte)(value >>> 24);
    }

    public static int getIntBE(byte[] array, int offset) {
        return array[offset + 3] & 0xFF | (array[offset + 2] & 0xFF) << 8 | (array[offset + 1] & 0xFF) << 16 | (array[offset] & 0xFF) << 24;
    }

    public static void putIntBE(byte[] array, int offset, int value) {
        array[offset + 3] = (byte)value;
        array[offset + 2] = (byte)(value >>> 8);
        array[offset + 1] = (byte)(value >>> 16);
        array[offset] = (byte)(value >>> 24);
    }

    public static long getLongLE(byte[] array, int offset) {
        return (long)array[offset] & 0xFFL | ((long)array[offset + 1] & 0xFFL) << 8 | ((long)array[offset + 2] & 0xFFL) << 16 | ((long)array[offset + 3] & 0xFFL) << 24 | ((long)array[offset + 4] & 0xFFL) << 32 | ((long)array[offset + 5] & 0xFFL) << 40 | ((long)array[offset + 6] & 0xFFL) << 48 | ((long)array[offset + 7] & 0xFFL) << 56;
    }

    public static void putLongLE(byte[] array, int offset, long value) {
        array[offset] = (byte)value;
        array[offset + 1] = (byte)(value >>> 8);
        array[offset + 2] = (byte)(value >>> 16);
        array[offset + 3] = (byte)(value >>> 24);
        array[offset + 4] = (byte)(value >>> 32);
        array[offset + 5] = (byte)(value >>> 40);
        array[offset + 6] = (byte)(value >>> 48);
        array[offset + 7] = (byte)(value >>> 56);
    }

    public static long getLongBE(byte[] array, int offset) {
        return (long)array[offset + 7] & 0xFFL | ((long)array[offset + 6] & 0xFFL) << 8 | ((long)array[offset + 5] & 0xFFL) << 16 | ((long)array[offset + 4] & 0xFFL) << 24 | ((long)array[offset + 3] & 0xFFL) << 32 | ((long)array[offset + 2] & 0xFFL) << 40 | ((long)array[offset + 1] & 0xFFL) << 48 | ((long)array[offset] & 0xFFL) << 56;
    }

    public static void putLongBE(byte[] array, int offset, long value) {
        array[offset + 7] = (byte)value;
        array[offset + 6] = (byte)(value >>> 8);
        array[offset + 5] = (byte)(value >>> 16);
        array[offset + 4] = (byte)(value >>> 24);
        array[offset + 3] = (byte)(value >>> 32);
        array[offset + 2] = (byte)(value >>> 40);
        array[offset + 1] = (byte)(value >>> 48);
        array[offset] = (byte)(value >>> 56);
    }

    public static float getFloatLE(byte[] array, int offset) {
        return Float.intBitsToFloat(ByteArrayUtil.getIntLE(array, offset));
    }

    public static void putFloatLE(byte[] array, int offset, float value) {
        ByteArrayUtil.putIntLE(array, offset, Float.floatToRawIntBits(value));
    }

    public static float getFloatBE(byte[] array, int offset) {
        return Float.intBitsToFloat(ByteArrayUtil.getIntBE(array, offset));
    }

    public static void putFloatBE(byte[] array, int offset, float value) {
        ByteArrayUtil.putIntBE(array, offset, Float.floatToRawIntBits(value));
    }

    public static double getDoubleLE(byte[] array, int offset) {
        return Double.longBitsToDouble(ByteArrayUtil.getLongLE(array, offset));
    }

    public static void putDoubleLE(byte[] array, int offset, double value) {
        ByteArrayUtil.putLongLE(array, offset, Double.doubleToRawLongBits(value));
    }

    public static double getDoubleBE(byte[] array, int offset) {
        return Double.longBitsToDouble(ByteArrayUtil.getLongBE(array, offset));
    }

    public static void putDoubleBE(byte[] array, int offset, double value) {
        ByteArrayUtil.putLongBE(array, offset, Double.doubleToRawLongBits(value));
    }
}

