/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.theta;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableMemory;
import org.apache.paimon.shade.org.apache.datasketches.theta.CompactSketch;
import org.apache.paimon.shade.org.apache.datasketches.theta.Sketch;
import org.apache.paimon.shade.org.apache.datasketches.theta.UpdateSketch;

interface ConcurrentSharedThetaSketch {
    public static final long NOT_SINGLE_HASH = -1L;
    public static final double MIN_ERROR = 1.0E-7;

    public static long computeExactLimit(long k, double error) {
        return 2L * Math.min(k, (long)Math.ceil(1.0 / Math.pow(Math.max(error, 1.0E-7), 2.0)));
    }

    public long getExactLimit();

    public boolean startEagerPropagation();

    public void endPropagation(AtomicBoolean var1, boolean var2);

    public long getVolatileTheta();

    public void awaitBgPropagationTermination();

    public void initBgPropagationService();

    public boolean propagate(AtomicBoolean var1, Sketch var2, long var3);

    public void propagate(long var1);

    public void updateEstimationSnapshot();

    public void updateVolatileTheta();

    public boolean validateEpoch(long var1);

    public int getCompactBytes();

    public int getCurrentBytes();

    public double getEstimate();

    public double getLowerBound(int var1);

    public double getUpperBound(int var1);

    public boolean hasMemory();

    public boolean isDirect();

    public boolean isEmpty();

    public boolean isEstimationMode();

    public byte[] toByteArray();

    public int getRetainedEntries(boolean var1);

    public CompactSketch compact();

    public CompactSketch compact(boolean var1, WritableMemory var2);

    public UpdateSketch rebuild();

    public void reset();
}

