/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.theta;

import org.apache.paimon.shade.org.apache.datasketches.common.SketchesArgumentException;
import org.apache.paimon.shade.org.apache.datasketches.memory.Memory;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableMemory;
import org.apache.paimon.shade.org.apache.datasketches.theta.CompactSketch;
import org.apache.paimon.shade.org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.paimon.shade.org.apache.datasketches.theta.HashIterator;
import org.apache.paimon.shade.org.apache.datasketches.theta.HeapCompactHashIterator;

final class EmptyCompactSketch
extends CompactSketch {
    private static final long EMPTY_SKETCH_MASK = 258385249304575L;
    private static final long EMPTY_SKETCH_TEST = 10995116475137L;
    static final byte[] EMPTY_COMPACT_SKETCH_ARR = new byte[]{1, 3, 3, 0, 0, 30, 0, 0};
    private static final EmptyCompactSketch EMPTY_COMPACT_SKETCH = new EmptyCompactSketch();

    private EmptyCompactSketch() {
    }

    static EmptyCompactSketch getInstance() {
        return EMPTY_COMPACT_SKETCH;
    }

    static EmptyCompactSketch getHeapInstance(Memory srcMem) {
        long pre0 = srcMem.getLong(0L);
        if (EmptyCompactSketch.testCandidatePre0(pre0)) {
            return EMPTY_COMPACT_SKETCH;
        }
        long maskedPre0 = pre0 & 0xEB0000FFFFFFL;
        throw new SketchesArgumentException("Input Memory does not match required Preamble. Memory Pre0: " + Long.toHexString(maskedPre0) + ", required Pre0: " + Long.toHexString(10995116475137L));
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory wmem) {
        if (wmem == null) {
            return EmptyCompactSketch.getInstance();
        }
        wmem.putByteArray(0L, EMPTY_COMPACT_SKETCH_ARR, 0, 8);
        return new DirectCompactSketch(wmem);
    }

    static boolean testCandidatePre0(long candidate) {
        return (candidate & 0xEB0000FFFFFFL) == 10995116475137L;
    }

    @Override
    public int getCurrentBytes() {
        return 8;
    }

    @Override
    public double getEstimate() {
        return 0.0;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return 0;
    }

    @Override
    public long getThetaLong() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public HashIterator iterator() {
        return new HeapCompactHashIterator(new long[0]);
    }

    @Override
    public byte[] toByteArray() {
        return EMPTY_COMPACT_SKETCH_ARR;
    }

    @Override
    long[] getCache() {
        return new long[0];
    }

    @Override
    int getCompactPreambleLongs() {
        return 1;
    }

    @Override
    int getCurrentPreambleLongs() {
        return 1;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    short getSeedHash() {
        return 0;
    }
}

