/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.connector.job.JobExecutor;
import org.apache.gravitino.exceptions.NoSuchJobException;
import org.apache.gravitino.job.JobHandle;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.local.LocalJobExecutorConfigs;
import org.apache.gravitino.job.local.LocalProcessBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJobExecutor
implements JobExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(LocalJobExecutor.class);
    private static final String LOCAL_JOB_PREFIX = "local-job-";
    private static final long UNEXPIRED_TIME_IN_MS = -1L;
    private Map<String, String> configs;
    private BlockingQueue<Pair<String, JobTemplate>> waitingQueue;
    private ExecutorService jobExecutorService;
    private ExecutorService jobPollingExecutorService;
    private Map<String, Pair<JobHandle.Status, Long>> jobStatus;
    private final Object lock = new Object();
    private long jobStatusKeepTimeInMs;
    private ScheduledExecutorService jobStatusCleanupExecutor;
    private volatile boolean finished = false;
    private Map<String, Process> runningProcesses;

    @Override
    public void initialize(Map<String, String> configs) {
        this.configs = configs;
        int waitingQueueSize = configs.containsKey("waitingQueueSize") ? Integer.parseInt(configs.get("waitingQueueSize")) : 100;
        Preconditions.checkArgument((waitingQueueSize > 0 ? 1 : 0) != 0, (String)"Waiting queue size must be greater than 0, but got: %s", (int)waitingQueueSize);
        this.waitingQueue = new LinkedBlockingQueue<Pair<String, JobTemplate>>(waitingQueueSize);
        this.jobPollingExecutorService = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("LocalJobPollingExecutor-" + thread.getId());
            thread.setDaemon(true);
            return thread;
        });
        this.jobPollingExecutorService.submit(this::pollJob);
        int maxRunningJobs = configs.containsKey("maxRunningJobs") ? Integer.parseInt(configs.get("maxRunningJobs")) : LocalJobExecutorConfigs.DEFAULT_MAX_RUNNING_JOBS;
        Preconditions.checkArgument((maxRunningJobs > 0 ? 1 : 0) != 0, (String)"Max running jobs must be greater than 0, but got: %s", (int)maxRunningJobs);
        this.jobExecutorService = new ThreadPoolExecutor(0, maxRunningJobs, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("LocalJobExecutor-" + thread.getId());
            thread.setDaemon(true);
            return thread;
        });
        this.jobStatus = Maps.newHashMap();
        this.jobStatusKeepTimeInMs = configs.containsKey("jobStatusKeepTimeInMs") ? Long.parseLong(configs.get("jobStatusKeepTimeInMs")) : 3600000L;
        Preconditions.checkArgument((this.jobStatusKeepTimeInMs > 0L ? 1 : 0) != 0, (String)"Job status keep time must be greater than 0, but got: %s", (long)this.jobStatusKeepTimeInMs);
        long jobStatusCleanupIntervalInMs = this.jobStatusKeepTimeInMs / 10L;
        this.jobStatusCleanupExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("LocalJobStatusCleanup-" + thread.getId());
            thread.setDaemon(true);
            return thread;
        });
        this.jobStatusCleanupExecutor.scheduleAtFixedRate(this::cleanupJobStatus, jobStatusCleanupIntervalInMs, jobStatusCleanupIntervalInMs, TimeUnit.MILLISECONDS);
        this.runningProcesses = Maps.newConcurrentMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String submitJob(JobTemplate jobTemplate) {
        String newJobId = LOCAL_JOB_PREFIX + String.valueOf(UUID.randomUUID());
        Pair jobPair = Pair.of((Object)newJobId, (Object)jobTemplate);
        Object object = this.lock;
        synchronized (object) {
            if (!this.waitingQueue.offer((Pair<String, JobTemplate>)jobPair)) {
                throw new IllegalStateException("Waiting queue is full, cannot submit job: " + String.valueOf(jobTemplate));
            }
            this.jobStatus.put(newJobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.QUEUED, (Object)-1L));
        }
        return newJobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobHandle.Status getJobStatus(String jobId) throws NoSuchJobException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.jobStatus.containsKey(jobId)) {
                throw new NoSuchJobException("No job found with ID: %s", new Object[]{jobId});
            }
            LOG.debug("Get status {} and finished time {} for job {}", new Object[]{this.jobStatus.get(jobId).getLeft(), this.jobStatus.get(jobId).getRight(), jobId});
            return (JobHandle.Status)this.jobStatus.get(jobId).getLeft();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelJob(String jobId) throws NoSuchJobException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.jobStatus.containsKey(jobId)) {
                throw new NoSuchJobException("No job found with ID: %s", new Object[]{jobId});
            }
            Pair<JobHandle.Status, Long> statusPair = this.jobStatus.get(jobId);
            if (statusPair.getLeft() == JobHandle.Status.SUCCEEDED || statusPair.getLeft() == JobHandle.Status.FAILED || statusPair.getLeft() == JobHandle.Status.CANCELLED) {
                LOG.warn("Job {} is already completed or cancelled, no action taken", (Object)jobId);
                return;
            }
            if (statusPair.getLeft() == JobHandle.Status.CANCELLING) {
                LOG.warn("Job {} is already being cancelled, no action taken", (Object)jobId);
                return;
            }
            if (statusPair.getLeft() == JobHandle.Status.QUEUED) {
                this.waitingQueue.removeIf(p -> ((String)p.getLeft()).equals(jobId));
                this.jobStatus.put(jobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.CANCELLED, (Object)System.currentTimeMillis()));
                LOG.info("Job {} is cancelled from the waiting queue", (Object)jobId);
                return;
            }
            if (statusPair.getLeft() == JobHandle.Status.STARTED) {
                Process process = this.runningProcesses.get(jobId);
                if (process != null) {
                    process.destroy();
                }
                LOG.info("Job {} is cancelling while running", (Object)jobId);
                this.jobStatus.put(jobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.CANCELLING, (Object)-1L));
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.finished = true;
        this.jobPollingExecutorService.shutdownNow();
        if (!this.waitingQueue.isEmpty()) {
            LOG.warn("There are still {} jobs in the waiting queue, they will not be processed.", (Object)this.waitingQueue.size());
            this.waitingQueue.clear();
        }
        this.runningProcesses.forEach((key, process) -> {
            if (process != null) {
                process.destroy();
            }
        });
        this.runningProcesses.clear();
        this.jobExecutorService.shutdownNow();
        this.jobStatusCleanupExecutor.shutdownNow();
        this.jobStatus.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob(Pair<String, JobTemplate> jobPair) {
        block19: {
            try {
                Object object;
                Process process;
                String jobId = (String)jobPair.getLeft();
                JobTemplate jobTemplate = (JobTemplate)jobPair.getRight();
                Object object2 = this.lock;
                synchronized (object2) {
                    Pair<JobHandle.Status, Long> statusPair = this.jobStatus.get(jobId);
                    if (statusPair == null || statusPair.getLeft() != JobHandle.Status.QUEUED) {
                        LOG.warn("Job {} is not in QUEUED state, cannot start it", (Object)jobId);
                        return;
                    }
                    LocalProcessBuilder processBuilder = LocalProcessBuilder.create(jobTemplate, this.configs);
                    process = processBuilder.start();
                    this.runningProcesses.put(jobId, process);
                    this.jobStatus.put(jobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.STARTED, (Object)-1L));
                }
                LOG.info("Starting job: {}", (Object)jobId);
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    LOG.info("Job {} completed successfully", (Object)jobId);
                    object = this.lock;
                    synchronized (object) {
                        this.jobStatus.put(jobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.SUCCEEDED, (Object)System.currentTimeMillis()));
                        break block19;
                    }
                }
                object = this.lock;
                synchronized (object) {
                    JobHandle.Status oldStatus = (JobHandle.Status)this.jobStatus.get(jobId).getLeft();
                    if (oldStatus == JobHandle.Status.CANCELLING) {
                        LOG.info("Job {} was cancelled while running with exit code: {}", (Object)jobId, (Object)exitCode);
                        this.jobStatus.put(jobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.CANCELLED, (Object)System.currentTimeMillis()));
                    } else if (oldStatus == JobHandle.Status.STARTED) {
                        LOG.warn("Job {} failed after starting with exit code: {}", (Object)jobId, (Object)exitCode);
                        this.jobStatus.put(jobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.FAILED, (Object)System.currentTimeMillis()));
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error while executing job", (Throwable)e);
                Object object = this.lock;
                synchronized (object) {
                    String jobId = (String)jobPair.getLeft();
                    this.jobStatus.put(jobId, (Pair<JobHandle.Status, Long>)Pair.of((Object)JobHandle.Status.FAILED, (Object)System.currentTimeMillis()));
                }
            }
        }
        this.runningProcesses.remove(jobPair.getLeft());
    }

    public void pollJob() {
        while (!this.finished) {
            try {
                Pair<String, JobTemplate> jobPair = this.waitingQueue.poll(3000L, TimeUnit.MILLISECONDS);
                if (jobPair == null) continue;
                this.jobExecutorService.submit(() -> this.runJob(jobPair));
            }
            catch (InterruptedException e) {
                LOG.warn("Polling job interrupted");
                this.finished = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void cleanupJobStatus() {
        long currentTime = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.jobStatus.entrySet().removeIf(entry -> (Long)((Pair)entry.getValue()).getRight() != -1L && currentTime - (Long)((Pair)entry.getValue()).getRight() >= this.jobStatusKeepTimeInMs);
        }
    }
}

