/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.utils;

import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.gravitino.catalog.jdbc.config.JdbcConfig;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.utils.JdbcUrlUtils;

public class DataSourceUtils {
    private static final String POOL_TEST_QUERY = "SELECT 1";

    public static DataSource createDataSource(Map<String, String> properties) {
        return DataSourceUtils.createDataSource(new JdbcConfig(properties));
    }

    public static DataSource createDataSource(JdbcConfig jdbcConfig) throws GravitinoRuntimeException {
        try {
            return DataSourceUtils.createDBCPDataSource(jdbcConfig);
        }
        catch (Exception exception) {
            throw new GravitinoRuntimeException((Throwable)exception, "Error creating datasource", new Object[0]);
        }
    }

    private static DataSource createDBCPDataSource(JdbcConfig jdbcConfig) throws Exception {
        JdbcUrlUtils.validateJdbcConfig((String)jdbcConfig.getJdbcDriver(), (String)jdbcConfig.getJdbcUrl(), (Map)jdbcConfig.getAllConfig());
        BasicDataSource basicDataSource = BasicDataSourceFactory.createDataSource((Properties)DataSourceUtils.getProperties(jdbcConfig));
        String jdbcUrl = jdbcConfig.getJdbcUrl();
        basicDataSource.setUrl(jdbcUrl);
        String driverClassName = jdbcConfig.getJdbcDriver();
        basicDataSource.setDriverClassName(driverClassName);
        String userName = jdbcConfig.getUsername();
        basicDataSource.setUsername(userName);
        String password = jdbcConfig.getPassword();
        basicDataSource.setPassword(password);
        basicDataSource.setMaxTotal(jdbcConfig.getPoolMaxSize());
        basicDataSource.setMinIdle(jdbcConfig.getPoolMinSize());
        basicDataSource.setTestOnBorrow(jdbcConfig.getTestOnBorrow());
        basicDataSource.setValidationQuery(POOL_TEST_QUERY);
        return basicDataSource;
    }

    private static Properties getProperties(JdbcConfig jdbcConfig) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)jdbcConfig.getAllConfig());
        return properties;
    }

    private static String recursiveDecode(String url) {
        String prev;
        String decoded = url;
        int max = 5;
        do {
            prev = decoded;
            try {
                decoded = URLDecoder.decode(prev, "UTF-8");
            }
            catch (Exception e) {
                throw new GravitinoRuntimeException("Unable to decode JDBC URL");
            }
        } while (!prev.equals(decoded) && --max > 0);
        return decoded;
    }

    public static void closeDataSource(DataSource dataSource) {
        if (null != dataSource) {
            try {
                if (!(dataSource instanceof BasicDataSource)) {
                    throw new UnsupportedOperationException("close operation can only be called in BasicDataSource.");
                }
                ((BasicDataSource)dataSource).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private DataSourceUtils() {
    }
}

