/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;
import org.apache.gravitino.dto.requests.RoleCreateRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.RoleResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.server.authorization.MetadataFilterHelper;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/roles")
public class RoleOperations {
    private static final Logger LOG = LoggerFactory.getLogger(RoleOperations.class);
    private final AccessControlDispatcher accessControlManager = GravitinoEnv.getInstance().accessControlDispatcher();
    @Context
    private HttpServletRequest httpRequest;

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-role", absolute=true)
    public Response listRoles(@PathParam(value="metalake") String metalake) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                String[] names = this.accessControlManager.listRoleNames(metalake);
                names = Arrays.stream(names).filter(role -> {
                    NameIdentifier[] nameIdentifiers = new NameIdentifier[]{NameIdentifierUtil.ofRole((String)metalake, (String)role)};
                    return MetadataFilterHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || ROLE::OWNER || ROLE::SELF", (Entity.EntityType)Entity.EntityType.ROLE, (NameIdentifier[])nameIdentifiers).length > 0;
                }).collect(Collectors.toList()).toArray(new String[0]);
                return Utils.ok((Object)new NameListResponse(names));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.LIST, "", metalake, e);
        }
    }

    @GET
    @Path(value="{role}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-role", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || ROLE::OWNER || ROLE::SELF")
    public Response getRole(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="role") @AuthorizationMetadata(type=Entity.EntityType.ROLE) String role) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> Utils.ok((Object)new RoleResponse(DTOConverters.toDTO((Role)this.accessControlManager.getRole(metalake, role)))));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.GET, role, metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-role", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::CREATE_ROLE")
    public Response createRole(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, RoleCreateRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                HashSet metadataObjects = Sets.newHashSet();
                for (SecurableObjectDTO object : request.getSecurableObjects()) {
                    MetadataObject metadataObject = MetadataObjects.parse((String)object.getFullName(), (MetadataObject.Type)object.type());
                    if (metadataObjects.contains(metadataObject)) {
                        throw new IllegalArgumentException(String.format("Doesn't support specifying duplicated securable objects %s type %s", object.fullName(), object.type()));
                    }
                    metadataObjects.add(metadataObject);
                    HashSet privileges = Sets.newHashSet((Iterable)object.privileges());
                    AuthorizationUtils.checkDuplicatedNamePrivilege((Collection)privileges);
                    try {
                        for (Privilege privilege : object.privileges()) {
                            AuthorizationUtils.checkPrivilege((PrivilegeDTO)((PrivilegeDTO)privilege), (MetadataObject)object, (String)metalake);
                        }
                        MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                    }
                    catch (NoSuchMetadataObjectException nsm) {
                        throw new IllegalMetadataObjectException((Throwable)nsm);
                    }
                }
                List securableObjects = Arrays.stream(request.getSecurableObjects()).map(securableObjectDTO -> SecurableObjects.parse((String)securableObjectDTO.fullName(), (MetadataObject.Type)securableObjectDTO.type(), securableObjectDTO.privileges().stream().map(privilege -> DTOConverters.fromPrivilegeDTO((PrivilegeDTO)((PrivilegeDTO)privilege))).collect(Collectors.toList()))).collect(Collectors.toList());
                return Utils.ok((Object)new RoleResponse(DTOConverters.toDTO((Role)this.accessControlManager.createRole(metalake, request.getName(), request.getProperties(), securableObjects))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.CREATE, request.getName(), metalake, e);
        }
    }

    @DELETE
    @Path(value="{role}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-role", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || ROLE::OWNER")
    public Response deleteRole(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="role") @AuthorizationMetadata(type=Entity.EntityType.ROLE) String role) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean deleted = this.accessControlManager.deleteRole(metalake, role);
                if (!deleted) {
                    LOG.warn("Failed to delete role {} under metalake {}", (Object)role, (Object)metalake);
                }
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(deleted), Boolean.valueOf(deleted)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.DELETE, role, metalake, e);
        }
    }
}

