/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.IllegalRoleException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;

public interface AccessControlDispatcher {
    public User addUser(String var1, String var2) throws UserAlreadyExistsException, NoSuchMetalakeException;

    public boolean removeUser(String var1, String var2) throws NoSuchMetalakeException;

    public User getUser(String var1, String var2) throws NoSuchUserException, NoSuchMetalakeException;

    public User[] listUsers(String var1) throws NoSuchMetalakeException;

    public String[] listUserNames(String var1) throws NoSuchMetalakeException;

    public Group addGroup(String var1, String var2) throws GroupAlreadyExistsException, NoSuchMetalakeException;

    public boolean removeGroup(String var1, String var2) throws NoSuchMetalakeException;

    public Group getGroup(String var1, String var2) throws NoSuchGroupException, NoSuchMetalakeException;

    public Group[] listGroups(String var1);

    public String[] listGroupNames(String var1);

    public User grantRolesToUser(String var1, List<String> var2, String var3) throws NoSuchUserException, IllegalRoleException, NoSuchMetalakeException;

    public Group grantRolesToGroup(String var1, List<String> var2, String var3) throws NoSuchGroupException, IllegalRoleException, NoSuchMetalakeException;

    public Group revokeRolesFromGroup(String var1, List<String> var2, String var3) throws NoSuchGroupException, IllegalRoleException, NoSuchMetalakeException;

    public User revokeRolesFromUser(String var1, List<String> var2, String var3) throws NoSuchUserException, IllegalRoleException, NoSuchMetalakeException;

    public boolean isServiceAdmin(String var1);

    public Role createRole(String var1, String var2, Map<String, String> var3, List<SecurableObject> var4) throws RoleAlreadyExistsException, NoSuchMetalakeException;

    public Role getRole(String var1, String var2) throws NoSuchRoleException, NoSuchMetalakeException;

    public boolean deleteRole(String var1, String var2) throws NoSuchMetalakeException;

    public String[] listRoleNames(String var1) throws NoSuchMetalakeException;

    public String[] listRoleNamesByObject(String var1, MetadataObject var2) throws NoSuchMetalakeException, NoSuchMetadataObjectException;

    public Role grantPrivilegeToRole(String var1, String var2, MetadataObject var3, Set<Privilege> var4) throws NoSuchGroupException, NoSuchRoleException;

    public Role revokePrivilegesFromRole(String var1, String var2, MetadataObject var3, Set<Privilege> var4) throws NoSuchMetalakeException, NoSuchRoleException;
}

