/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;

@Evolving
public abstract class BasePropertiesMetadata
implements PropertiesMetadata {
    protected static final Map<String, PropertyEntry<?>> BASIC_PROPERTY_ENTRIES;
    protected volatile Map<String, PropertyEntry<?>> propertyEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, PropertyEntry<?>> propertyEntries() {
        if (this.propertyEntries == null) {
            BasePropertiesMetadata basePropertiesMetadata = this;
            synchronized (basePropertiesMetadata) {
                if (this.propertyEntries == null) {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    Map<String, PropertyEntry<?>> properties = this.specificPropertyEntries();
                    builder.putAll(properties);
                    BASIC_PROPERTY_ENTRIES.forEach((name, entry) -> {
                        Preconditions.checkArgument((!properties.containsKey(name) ? 1 : 0) != 0, (Object)("Property metadata already exists: " + name));
                        builder.put(name, entry);
                    });
                    this.propertyEntries = builder.build();
                }
            }
        }
        return this.propertyEntries;
    }

    @Evolving
    protected abstract Map<String, PropertyEntry<?>> specificPropertyEntries();

    static {
        ImmutableList basicPropertyEntries = ImmutableList.of(PropertyEntry.stringReservedPropertyEntry("gravitino.identifier", "To differentiate the entities created directly by the underlying sources", true));
        BASIC_PROPERTY_ENTRIES = Maps.uniqueIndex((Iterable)basicPropertyEntries, PropertyEntry::getName);
    }
}

