/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class ModelPO {
    private Long modelId;
    private String modelName;
    private Long metalakeId;
    private Long catalogId;
    private Long schemaId;
    private String modelComment;
    private Integer modelLatestVersion;
    private String modelProperties;
    private String auditInfo;
    private Long deletedAt;

    private ModelPO() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelPO)) {
            return false;
        }
        ModelPO other = (ModelPO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$modelId = this.getModelId();
        Long other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        Long this$metalakeId = this.getMetalakeId();
        Long other$metalakeId = other.getMetalakeId();
        if (this$metalakeId == null ? other$metalakeId != null : !((Object)this$metalakeId).equals(other$metalakeId)) {
            return false;
        }
        Long this$catalogId = this.getCatalogId();
        Long other$catalogId = other.getCatalogId();
        if (this$catalogId == null ? other$catalogId != null : !((Object)this$catalogId).equals(other$catalogId)) {
            return false;
        }
        Long this$schemaId = this.getSchemaId();
        Long other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !((Object)this$schemaId).equals(other$schemaId)) {
            return false;
        }
        Integer this$modelLatestVersion = this.getModelLatestVersion();
        Integer other$modelLatestVersion = other.getModelLatestVersion();
        if (this$modelLatestVersion == null ? other$modelLatestVersion != null : !((Object)this$modelLatestVersion).equals(other$modelLatestVersion)) {
            return false;
        }
        Long this$deletedAt = this.getDeletedAt();
        Long other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$modelComment = this.getModelComment();
        String other$modelComment = other.getModelComment();
        if (this$modelComment == null ? other$modelComment != null : !this$modelComment.equals(other$modelComment)) {
            return false;
        }
        String this$modelProperties = this.getModelProperties();
        String other$modelProperties = other.getModelProperties();
        if (this$modelProperties == null ? other$modelProperties != null : !this$modelProperties.equals(other$modelProperties)) {
            return false;
        }
        String this$auditInfo = this.getAuditInfo();
        String other$auditInfo = other.getAuditInfo();
        return !(this$auditInfo == null ? other$auditInfo != null : !this$auditInfo.equals(other$auditInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelPO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        Long $metalakeId = this.getMetalakeId();
        result = result * 59 + ($metalakeId == null ? 43 : ((Object)$metalakeId).hashCode());
        Long $catalogId = this.getCatalogId();
        result = result * 59 + ($catalogId == null ? 43 : ((Object)$catalogId).hashCode());
        Long $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : ((Object)$schemaId).hashCode());
        Integer $modelLatestVersion = this.getModelLatestVersion();
        result = result * 59 + ($modelLatestVersion == null ? 43 : ((Object)$modelLatestVersion).hashCode());
        Long $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $modelComment = this.getModelComment();
        result = result * 59 + ($modelComment == null ? 43 : $modelComment.hashCode());
        String $modelProperties = this.getModelProperties();
        result = result * 59 + ($modelProperties == null ? 43 : $modelProperties.hashCode());
        String $auditInfo = this.getAuditInfo();
        result = result * 59 + ($auditInfo == null ? 43 : $auditInfo.hashCode());
        return result;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public String getModelComment() {
        return this.modelComment;
    }

    public Integer getModelLatestVersion() {
        return this.modelLatestVersion;
    }

    public String getModelProperties() {
        return this.modelProperties;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private final ModelPO modelPO = new ModelPO();

        private Builder() {
        }

        public Builder withModelId(Long modelId) {
            this.modelPO.modelId = modelId;
            return this;
        }

        public Builder withModelName(String modelName) {
            this.modelPO.modelName = modelName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.modelPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withCatalogId(Long catalogId) {
            this.modelPO.catalogId = catalogId;
            return this;
        }

        public Builder withSchemaId(Long schemaId) {
            this.modelPO.schemaId = schemaId;
            return this;
        }

        public Builder withModelComment(String modelComment) {
            this.modelPO.modelComment = modelComment;
            return this;
        }

        public Builder withModelLatestVersion(Integer modelLatestVersion) {
            this.modelPO.modelLatestVersion = modelLatestVersion;
            return this;
        }

        public Builder withModelProperties(String modelProperties) {
            this.modelPO.modelProperties = modelProperties;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.modelPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.modelPO.deletedAt = deletedAt;
            return this;
        }

        public ModelPO build() {
            Preconditions.checkArgument((this.modelPO.modelId != null ? 1 : 0) != 0, (Object)"Model id is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.modelPO.modelName), (Object)"Model name cannot be empty");
            Preconditions.checkArgument((this.modelPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.modelPO.catalogId != null ? 1 : 0) != 0, (Object)"Catalog id is required");
            Preconditions.checkArgument((this.modelPO.schemaId != null ? 1 : 0) != 0, (Object)"Schema id is required");
            Preconditions.checkArgument((this.modelPO.modelLatestVersion != null ? 1 : 0) != 0, (Object)"Model latest version is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.modelPO.auditInfo), (Object)"Audit info cannot be empty");
            Preconditions.checkArgument((this.modelPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
            return this.modelPO;
        }
    }
}

