/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.connector.job.JobExecutor;
import org.apache.gravitino.job.local.LocalJobExecutor;

public class JobExecutorFactory {
    private static final String JOB_EXECUTOR_CONF_PREFIX = "gravitino.jobExecutor.";
    private static final String JOB_EXECUTOR_CLASS_SUFFIX = ".class";
    private static final Map<String, String> BUILTIN_EXECUTORS = ImmutableMap.of((Object)"local", (Object)LocalJobExecutor.class.getCanonicalName());

    private JobExecutorFactory() {
    }

    public static JobExecutor create(Config config) {
        String clzName;
        String jobExecutorName = (String)config.get(Configs.JOB_EXECUTOR);
        if (BUILTIN_EXECUTORS.containsKey(jobExecutorName)) {
            clzName = BUILTIN_EXECUTORS.get(jobExecutorName);
        } else {
            String jobExecutorClassKey = JOB_EXECUTOR_CONF_PREFIX + jobExecutorName + JOB_EXECUTOR_CLASS_SUFFIX;
            clzName = config.getRawString(jobExecutorClassKey);
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)clzName), (String)"Job executor class name must be specified for job executor: %s", (Object)jobExecutorName);
        Map configs = config.getConfigsWithPrefix(JOB_EXECUTOR_CONF_PREFIX + jobExecutorName + ".");
        try {
            JobExecutor jobExecutor = (JobExecutor)Class.forName(clzName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            jobExecutor.initialize(configs);
            return jobExecutor;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create job executor: " + jobExecutorName, e);
        }
    }
}

