/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.paimon.deletionvectors.DeletionFileWriter;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.PathFactory;

public class DeletionVectorIndexFileWriter {
    private final PathFactory indexPathFactory;
    private final FileIO fileIO;
    private final long targetSizeInBytes;

    public DeletionVectorIndexFileWriter(FileIO fileIO, PathFactory pathFactory, MemorySize targetSizePerIndexFile) {
        this.indexPathFactory = pathFactory;
        this.fileIO = fileIO;
        this.targetSizeInBytes = targetSizePerIndexFile.getBytes();
    }

    public List<IndexFileMeta> write(Map<String, DeletionVector> input) throws IOException {
        if (input.isEmpty()) {
            return this.emptyIndexFile();
        }
        ArrayList<IndexFileMeta> result = new ArrayList<IndexFileMeta>();
        Iterator<Map.Entry<String, DeletionVector>> iterator = input.entrySet().iterator();
        while (iterator.hasNext()) {
            result.add(this.tryWriter(iterator));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexFileMeta tryWriter(Iterator<Map.Entry<String, DeletionVector>> iterator) throws IOException {
        try (DeletionFileWriter writer = new DeletionFileWriter(this.indexPathFactory.newPath(), this.fileIO);){
            while (iterator.hasNext()) {
                Map.Entry<String, DeletionVector> entry = iterator.next();
                writer.write(entry.getKey(), entry.getValue());
                if (writer.getPos() <= this.targetSizeInBytes) continue;
                break;
            }
        }
        return writer.result();
    }

    private List<IndexFileMeta> emptyIndexFile() throws IOException {
        DeletionFileWriter writer = new DeletionFileWriter(this.indexPathFactory.newPath(), this.fileIO);
        writer.close();
        return Collections.singletonList(writer.result());
    }
}

