/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.lookup.ByteArray;
import org.apache.paimon.lookup.SetState;
import org.apache.paimon.lookup.rocksdb.RocksDBState;
import org.apache.paimon.lookup.rocksdb.RocksDBStateFactory;
import org.apache.paimon.utils.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDBSetState<K, V>
extends RocksDBState<K, V, List<byte[]>>
implements SetState<K, V> {
    private static final byte[] EMPTY = new byte[0];

    public RocksDBSetState(RocksDBStateFactory stateFactory, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        super(stateFactory, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    @Override
    public List<V> get(K key) throws IOException {
        ByteArray keyBytes = this.wrap(this.serializeKey(key));
        ArrayList<byte[]> valueBytes = (ArrayList<byte[]>)this.cache.getIfPresent((Object)keyBytes);
        if (valueBytes == null) {
            valueBytes = new ArrayList<byte[]>();
            RocksIterator iterator = this.db.newIterator(this.columnFamily);
            Object object = null;
            try {
                iterator.seek(keyBytes.bytes);
                while (iterator.isValid() && this.startWithKeyPrefix(keyBytes.bytes, iterator.key())) {
                    byte[] rawKeyBytes = iterator.key();
                    byte[] value = Arrays.copyOfRange(rawKeyBytes, keyBytes.bytes.length, rawKeyBytes.length);
                    valueBytes.add(value);
                    iterator.next();
                }
            }
            catch (Throwable rawKeyBytes) {
                object = rawKeyBytes;
                throw rawKeyBytes;
            }
            finally {
                if (iterator != null) {
                    if (object != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable rawKeyBytes) {
                            ((Throwable)object).addSuppressed(rawKeyBytes);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
            this.cache.put((Object)keyBytes, valueBytes);
        }
        ArrayList<Object> values = new ArrayList<Object>(valueBytes.size());
        for (byte[] value : valueBytes) {
            this.valueInputView.setBuffer(value);
            values.add(this.valueSerializer.deserialize((DataInputView)this.valueInputView));
        }
        return values;
    }

    @Override
    public void retract(K key, V value) throws IOException {
        try {
            byte[] bytes = this.invalidKeyAndGetKVBytes(key, value);
            if (this.db.get(this.columnFamily, bytes) != null) {
                this.db.delete(this.columnFamily, this.writeOptions, bytes);
            }
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void add(K key, V value) throws IOException {
        try {
            byte[] bytes = this.invalidKeyAndGetKVBytes(key, value);
            this.db.put(this.columnFamily, this.writeOptions, bytes, EMPTY);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    private byte[] invalidKeyAndGetKVBytes(K key, V value) throws IOException {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        this.keyOutView.clear();
        this.keySerializer.serialize(key, (DataOutputView)this.keyOutView);
        this.cache.invalidate((Object)this.wrap(this.keyOutView.getCopyOfBuffer()));
        this.valueSerializer.serialize(value, (DataOutputView)this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    private boolean startWithKeyPrefix(byte[] keyPrefixBytes, byte[] rawKeyBytes) {
        if (rawKeyBytes.length < keyPrefixBytes.length) {
            return false;
        }
        int i = keyPrefixBytes.length;
        while (--i >= 0) {
            if (rawKeyBytes[i] == keyPrefixBytes[i]) continue;
            return false;
        }
        return true;
    }
}

