/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.policy;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.policy.PolicyContent;

@Evolving
public interface PolicyChange {
    public static PolicyChange rename(String newName) {
        return new RenamePolicy(newName);
    }

    public static PolicyChange updateComment(String newComment) {
        return new UpdatePolicyComment(newComment);
    }

    public static PolicyChange updateContent(String policyType, PolicyContent content) {
        return new UpdateContent(policyType, content);
    }

    public static final class RenamePolicy
    implements PolicyChange {
        private final String newName;

        private RenamePolicy(String newName) {
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenamePolicy that = (RenamePolicy)o;
            return Objects.equals(this.newName, that.newName);
        }

        public int hashCode() {
            return Objects.hashCode(this.newName);
        }

        public String toString() {
            return "RENAME POLICY " + this.newName;
        }
    }

    public static final class UpdatePolicyComment
    implements PolicyChange {
        private final String newComment;

        private UpdatePolicyComment(String newComment) {
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdatePolicyComment that = (UpdatePolicyComment)o;
            return Objects.equals(this.newComment, that.newComment);
        }

        public int hashCode() {
            return Objects.hashCode(this.newComment);
        }

        public String toString() {
            return "UPDATE POLICY COMMENT " + this.newComment;
        }
    }

    public static final class UpdateContent
    implements PolicyChange {
        private final String policyType;
        private final PolicyContent content;

        private UpdateContent(String policyType, PolicyContent content) {
            this.policyType = policyType;
            this.content = content;
        }

        public String getPolicyType() {
            return this.policyType;
        }

        public PolicyContent getContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UpdateContent)) {
                return false;
            }
            UpdateContent that = (UpdateContent)o;
            return Objects.equals(this.policyType, that.policyType) && Objects.equals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hash(this.policyType, this.content);
        }

        public String toString() {
            return "UPDATE POLICY CONTENT policyType=" + this.policyType + ", content=" + String.valueOf(this.content);
        }
    }
}

