/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.JobTemplateEntity;
import org.apache.gravitino.storage.relational.mapper.JobMetaMapper;
import org.apache.gravitino.storage.relational.mapper.JobTemplateMetaMapper;
import org.apache.gravitino.storage.relational.po.JobTemplatePO;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.SessionUtils;

public class JobTemplateMetaService {
    private static final JobTemplateMetaService INSTANCE = new JobTemplateMetaService();

    private JobTemplateMetaService() {
    }

    public static JobTemplateMetaService getInstance() {
        return INSTANCE;
    }

    public List<JobTemplateEntity> listJobTemplatesByNamespace(Namespace ns) {
        String metalakeName = ns.level(0);
        List jobTemplatePOs = SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.listJobTemplatePOsByMetalake(metalakeName));
        return jobTemplatePOs.stream().map(p -> JobTemplatePO.fromJobTemplatePO(p, ns)).collect(Collectors.toList());
    }

    public JobTemplateEntity getJobTemplateByIdentifier(NameIdentifier jobTemplateIdent) {
        JobTemplatePO jobTemplatePO = this.getJobTemplatePO(jobTemplateIdent);
        return JobTemplatePO.fromJobTemplatePO(jobTemplatePO, jobTemplateIdent.namespace());
    }

    public void insertJobTemplate(JobTemplateEntity jobTemplateEntity, boolean overwrite) throws IOException {
        String metalakeName = jobTemplateEntity.namespace().level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalakeName);
            JobTemplatePO.JobTemplatePOBuilder builder = JobTemplatePO.builder().withMetalakeId(metalakeId);
            JobTemplatePO jobTemplatePO = JobTemplatePO.initializeJobTemplatePO(jobTemplateEntity, builder);
            SessionUtils.doWithCommit(JobTemplateMetaMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertJobTemplateMetaOnDuplicateKeyUpdate(jobTemplatePO);
                } else {
                    mapper.insertJobTemplateMeta(jobTemplatePO);
                }
            });
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.JOB_TEMPLATE, jobTemplateEntity.name());
            throw e;
        }
    }

    public boolean deleteJobTemplate(NameIdentifier jobTemplateIdent) {
        String metalakeName = jobTemplateIdent.namespace().level(0);
        String jobTemplateName = jobTemplateIdent.name();
        AtomicInteger result = new AtomicInteger(0);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetaByMetalakeAndTemplate(metalakeName, jobTemplateName)), () -> result.set(SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.softDeleteJobTemplateMetaByMetalakeAndName(metalakeName, jobTemplateName))));
        return result.get() > 0;
    }

    public int deleteJobTemplatesByLegacyTimeline(long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(JobTemplateMetaMapper.class, mapper -> mapper.deleteJobTemplateMetasByLegacyTimeline(legacyTimeline, limit));
    }

    public <E extends Entity & HasIdentifier> JobTemplateEntity updateJobTemplate(NameIdentifier jobTemplateIdent, Function<E, E> updater) throws IOException {
        Integer result;
        JobTemplatePO oldJobTemplatePO = this.getJobTemplatePO(jobTemplateIdent);
        JobTemplateEntity oldJobTemplateEntity = JobTemplatePO.fromJobTemplatePO(oldJobTemplatePO, jobTemplateIdent.namespace());
        JobTemplateEntity newJobTemplateEntity = (JobTemplateEntity)updater.apply(oldJobTemplateEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldJobTemplateEntity.id(), newJobTemplateEntity.id()), (String)"The updated job templated id: %s is not equal to the old one: %s, which is unexpected", (Object)newJobTemplateEntity.id(), (Object)oldJobTemplateEntity.id());
        JobTemplatePO.JobTemplatePOBuilder newBuilder = JobTemplatePO.builder().withMetalakeId(oldJobTemplatePO.metalakeId());
        JobTemplatePO newJobTemplatePO = JobTemplatePO.updateJobTemplatePO(oldJobTemplatePO, newJobTemplateEntity, newBuilder);
        try {
            result = SessionUtils.doWithCommitAndFetchResult(JobTemplateMetaMapper.class, mapper -> mapper.updateJobTemplateMeta(newJobTemplatePO, oldJobTemplatePO));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.JOB_TEMPLATE, oldJobTemplateEntity.name());
            throw e;
        }
        if (result == null || result == 0) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB_TEMPLATE.name().toLowerCase(Locale.ROOT), oldJobTemplateEntity.name()});
        }
        if (result > 1) {
            throw new IOException(String.format("Failed to update job template: %s, because more than one rows are updated: %d", oldJobTemplateEntity.name(), result));
        }
        return newJobTemplateEntity;
    }

    private JobTemplatePO getJobTemplatePO(NameIdentifier jobTemplateIdent) {
        String jobTemplateName;
        String metalakeName = jobTemplateIdent.namespace().level(0);
        JobTemplatePO jobTemplatePO = SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, arg_0 -> JobTemplateMetaService.lambda$getJobTemplatePO$9(metalakeName, jobTemplateName = jobTemplateIdent.name(), arg_0));
        if (jobTemplatePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB_TEMPLATE.name().toLowerCase(Locale.ROOT), jobTemplateName});
        }
        return jobTemplatePO;
    }

    private static /* synthetic */ JobTemplatePO lambda$getJobTemplatePO$9(String metalakeName, String jobTemplateName, JobTemplateMetaMapper mapper) {
        return mapper.selectJobTemplatePOByMetalakeAndName(metalakeName, jobTemplateName);
    }
}

