/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import com.google.common.base.Preconditions;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergTable;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.ConvertUtil;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;

public class ToIcebergPartitionSpec {
    private static final String DOT = ".";

    public static PartitionSpec toPartitionSpec(IcebergTable icebergTable) {
        Schema schema = ConvertUtil.toIcebergSchema(icebergTable);
        return ToIcebergPartitionSpec.toPartitionSpec(schema, icebergTable.partitioning());
    }

    public static PartitionSpec toPartitionSpec(Schema schema, Transform[] partitioning) {
        if (partitioning == null || partitioning.length == 0) {
            return PartitionSpec.unpartitioned();
        }
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        for (Transform transform : partitioning) {
            if (transform instanceof Transforms.IdentityTransform) {
                CharSequence[] fieldName = ((Transforms.IdentityTransform)transform).fieldName();
                String colName = String.join((CharSequence)DOT, fieldName);
                builder.identity(colName);
                continue;
            }
            if (transform instanceof Transforms.BucketTransform) {
                String[][] fieldNames = ((Transforms.BucketTransform)transform).fieldNames();
                Preconditions.checkArgument((fieldNames.length == 1 ? 1 : 0) != 0, (String)"Iceberg partition does not support multi fields", (Object)transform);
                builder.bucket(String.join((CharSequence)DOT, fieldNames[0]), ((Transforms.BucketTransform)transform).numBuckets());
                continue;
            }
            if (transform instanceof Transforms.TruncateTransform) {
                Transforms.TruncateTransform truncateTransform = (Transforms.TruncateTransform)transform;
                builder.truncate(String.join((CharSequence)DOT, truncateTransform.fieldName()), truncateTransform.width());
                continue;
            }
            if (transform instanceof Transforms.YearTransform) {
                builder.year(String.join((CharSequence)DOT, ((Transforms.YearTransform)transform).fieldName()));
                continue;
            }
            if (transform instanceof Transforms.MonthTransform) {
                builder.month(String.join((CharSequence)DOT, ((Transforms.MonthTransform)transform).fieldName()));
                continue;
            }
            if (transform instanceof Transforms.DayTransform) {
                builder.day(String.join((CharSequence)DOT, ((Transforms.DayTransform)transform).fieldName()));
                continue;
            }
            if (transform instanceof Transforms.HourTransform) {
                builder.hour(String.join((CharSequence)DOT, ((Transforms.HourTransform)transform).fieldName()));
                continue;
            }
            throw new UnsupportedOperationException("Transform is not supported: " + transform.name());
        }
        return builder.build();
    }

    private ToIcebergPartitionSpec() {
    }
}

