/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.operation.Operation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.arrow.util.Preconditions;

public class Transaction {
    private final long readVersion;
    private final String uuid;
    private final Map<String, String> writeParams;
    private final Map<String, String> transactionProperties;
    private final Dataset dataset;
    private final Operation operation;
    private final Operation blobOp;

    private Transaction(Dataset dataset, long readVersion, String uuid, Operation operation, Operation blobOp, Map<String, String> writeParams, Map<String, String> transactionProperties) {
        this.dataset = dataset;
        this.readVersion = readVersion;
        this.uuid = uuid;
        this.operation = operation;
        this.blobOp = blobOp;
        this.writeParams = writeParams != null ? writeParams : new HashMap();
        this.transactionProperties = transactionProperties != null ? transactionProperties : new HashMap();
    }

    public long readVersion() {
        return this.readVersion;
    }

    public String uuid() {
        return this.uuid;
    }

    public Operation operation() {
        return this.operation;
    }

    public Operation blobsOperation() {
        return this.blobOp;
    }

    public Map<String, String> writeParams() {
        return this.writeParams;
    }

    public Map<String, String> transactionProperties() {
        return this.transactionProperties;
    }

    public Dataset commit() {
        if (this.dataset == null) {
            throw new UnsupportedOperationException("Transaction doesn't support create new dataset yet");
        }
        return this.dataset.commitTransaction(this);
    }

    public void release() {
        this.operation.release();
        if (this.blobOp != null) {
            this.blobOp.release();
        }
    }

    public String toString() {
        return String.format("Transaction{readVersion=%d, uuid='%s', operation=%s, blobOp=%s}", this.readVersion, this.uuid, this.operation, this.blobOp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.readVersion == that.readVersion && this.uuid.equals(that.uuid) && Objects.equals(this.operation, that.operation) && Objects.equals(this.blobOp, that.blobOp) && Objects.equals(this.writeParams, that.writeParams) && Objects.equals(this.transactionProperties, that.transactionProperties);
    }

    public static class Builder {
        private final String uuid;
        private final Dataset dataset;
        private long readVersion;
        private Operation operation;
        private Operation blobOp;
        private Map<String, String> writeParams;
        private Map<String, String> transactionProperties;

        public Builder(Dataset dataset) {
            this.dataset = dataset;
            this.uuid = UUID.randomUUID().toString();
        }

        public Builder readVersion(long readVersion) {
            this.readVersion = readVersion;
            return this;
        }

        public Builder transactionProperties(Map<String, String> properties) {
            this.transactionProperties = properties;
            return this;
        }

        public Builder writeParams(Map<String, String> writeParams) {
            this.writeParams = writeParams;
            return this;
        }

        public Builder operation(Operation operation) {
            this.validateState();
            this.operation = operation;
            return this;
        }

        private void validateState() {
            if (this.operation != null) {
                throw new IllegalStateException(String.format("Operation %s has been set", this.operation.name()));
            }
        }

        public Transaction build() {
            Preconditions.checkState((this.operation != null ? 1 : 0) != 0, (Object)"TransactionBuilder has no operations");
            return new Transaction(this.dataset, this.readVersion, this.uuid, this.operation, this.blobOp, this.writeParams, this.transactionProperties);
        }
    }
}

