/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.postgresql.converter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class PostgreSqlTypeConverter
extends JdbcTypeConverter {
    static final String BOOL = "bool";
    static final String INT_2 = "int2";
    static final String INT_4 = "int4";
    static final String INT_8 = "int8";
    static final String FLOAT_4 = "float4";
    static final String FLOAT_8 = "float8";
    static final String TIMESTAMP_TZ = "timestamptz";
    static final String NUMERIC = "numeric";
    static final String BPCHAR = "bpchar";
    static final String BYTEA = "bytea";
    @VisibleForTesting
    static final String JDBC_ARRAY_PREFIX = "_";
    @VisibleForTesting
    static final String ARRAY_TOKEN = "[]";

    public Type toGravitino(JdbcTypeConverter.JdbcTypeBean typeBean) {
        String typeName = typeBean.getTypeName().toLowerCase();
        if (typeName.startsWith(JDBC_ARRAY_PREFIX)) {
            return this.toGravitinoArrayType(typeName);
        }
        switch (typeName) {
            case "bool": {
                return Types.BooleanType.get();
            }
            case "int2": {
                return Types.ShortType.get();
            }
            case "int4": {
                return Types.IntegerType.get();
            }
            case "int8": {
                return Types.LongType.get();
            }
            case "float4": {
                return Types.FloatType.get();
            }
            case "float8": {
                return Types.DoubleType.get();
            }
            case "date": {
                return Types.DateType.get();
            }
            case "time": {
                return (Type)Optional.ofNullable(typeBean.getDatetimePrecision()).map(Types.TimeType::of).orElseGet(Types.TimeType::get);
            }
            case "timestamp": {
                return (Type)Optional.ofNullable(typeBean.getDatetimePrecision()).map(Types.TimestampType::withoutTimeZone).orElseGet(Types.TimestampType::withoutTimeZone);
            }
            case "timestamptz": {
                return (Type)Optional.ofNullable(typeBean.getDatetimePrecision()).map(Types.TimestampType::withTimeZone).orElseGet(Types.TimestampType::withTimeZone);
            }
            case "numeric": {
                return Types.DecimalType.of((int)typeBean.getColumnSize(), (int)typeBean.getScale());
            }
            case "varchar": {
                return typeBean.getColumnSize() == null ? Types.StringType.get() : Types.VarCharType.of((int)typeBean.getColumnSize());
            }
            case "bpchar": {
                return Types.FixedCharType.of((int)typeBean.getColumnSize());
            }
            case "text": {
                return Types.StringType.get();
            }
            case "bytea": {
                return Types.BinaryType.get();
            }
        }
        return Types.ExternalType.of((String)typeBean.getTypeName());
    }

    public String fromGravitino(Type type) {
        if (type instanceof Types.BooleanType) {
            return BOOL;
        }
        if (type instanceof Types.ShortType) {
            return INT_2;
        }
        if (type instanceof Types.IntegerType) {
            return INT_4;
        }
        if (type instanceof Types.LongType) {
            return INT_8;
        }
        if (type instanceof Types.FloatType) {
            return FLOAT_4;
        }
        if (type instanceof Types.DoubleType) {
            return FLOAT_8;
        }
        if (type instanceof Types.StringType) {
            return "text";
        }
        if (type instanceof Types.DateType) {
            return type.simpleString();
        }
        if (type instanceof Types.TimeType) {
            return type.simpleString();
        }
        if (type instanceof Types.TimestampType) {
            Types.TimestampType timestampType = (Types.TimestampType)type;
            String baseType = timestampType.hasTimeZone() ? TIMESTAMP_TZ : "timestamp";
            return timestampType.hasPrecisionSet() ? String.format("%s(%d)", baseType, timestampType.precision()) : baseType;
        }
        if (type instanceof Types.DecimalType) {
            return "numeric(" + ((Types.DecimalType)type).precision() + "," + ((Types.DecimalType)type).scale() + ")";
        }
        if (type instanceof Types.VarCharType) {
            return "varchar(" + ((Types.VarCharType)type).length() + ")";
        }
        if (type instanceof Types.FixedCharType) {
            return "bpchar(" + ((Types.FixedCharType)type).length() + ")";
        }
        if (type instanceof Types.BinaryType) {
            return BYTEA;
        }
        if (type instanceof Types.ListType) {
            return this.fromGravitinoArrayType((Types.ListType)type);
        }
        if (type instanceof Types.ExternalType) {
            return ((Types.ExternalType)type).catalogString();
        }
        throw new IllegalArgumentException(String.format("Couldn't convert Gravitino type %s to PostgreSQL type", type.simpleString()));
    }

    private String fromGravitinoArrayType(Types.ListType listType) {
        Type elementType = listType.elementType();
        Preconditions.checkArgument((!listType.elementNullable() ? 1 : 0) != 0, (Object)"PostgreSQL doesn't support element to nullable");
        Preconditions.checkArgument((!(elementType instanceof Types.ListType) ? 1 : 0) != 0, (Object)"PostgreSQL doesn't support multidimensional list internally, please use one dimensional list");
        String elementTypeString = this.fromGravitino(elementType);
        return elementTypeString + ARRAY_TOKEN;
    }

    private Types.ListType toGravitinoArrayType(String typeName) {
        String elementTypeName = typeName.substring(JDBC_ARRAY_PREFIX.length(), typeName.length());
        JdbcTypeConverter.JdbcTypeBean bean = new JdbcTypeConverter.JdbcTypeBean(elementTypeName);
        return Types.ListType.of((Type)this.toGravitino(bean), (boolean)false);
    }
}

