/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.fs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.utils.IOUtils;

public class FSDataWrappedInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private final SeekableInputStream seekableInputStream;

    public FSDataWrappedInputStream(SeekableInputStream seekableInputStream) {
        this.seekableInputStream = seekableInputStream;
    }

    public SeekableInputStream wrapped() {
        return this.seekableInputStream;
    }

    @Override
    public int read() throws IOException {
        return this.seekableInputStream.read();
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.seekableInputStream.seek(position);
        return this.seekableInputStream.read(buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.seekableInputStream.seek(position);
        IOUtils.readFully((InputStream)this.seekableInputStream, (byte[])buffer, (int)offset, (int)length);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void seek(long pos) throws IOException {
        this.seekableInputStream.seek(pos);
    }

    public long getPos() throws IOException {
        return this.seekableInputStream.getPos();
    }

    public boolean seekToNewSource(long targetPos) {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.seekableInputStream.close();
    }
}

