/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.gravitino.cli.CatalogCommandHandler;
import org.apache.gravitino.cli.ColumnCommandHandler;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FilesetCommandHandler;
import org.apache.gravitino.cli.GroupCommandHandler;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.MetalakeCommandHandler;
import org.apache.gravitino.cli.ModelCommandHandler;
import org.apache.gravitino.cli.OwnerCommandHandler;
import org.apache.gravitino.cli.RoleCommandHandler;
import org.apache.gravitino.cli.SchemaCommandHandler;
import org.apache.gravitino.cli.SimpleCommandHandler;
import org.apache.gravitino.cli.TableCommandHandler;
import org.apache.gravitino.cli.TagCommandHandler;
import org.apache.gravitino.cli.TestableCommandLine;
import org.apache.gravitino.cli.TopicCommandHandler;
import org.apache.gravitino.cli.UserCommandHandler;

public class GravitinoCommandLine
extends TestableCommandLine {
    private final CommandLine line;
    private final Options options;
    private final String entity;
    private final String command;
    public static final String CMD = "gcli";
    public static final String DEFAULT_URL = "http://localhost:8090";

    public GravitinoCommandLine(CommandLine line, Options options, String entity, String command) {
        this.line = line;
        this.options = options;
        this.entity = entity;
        this.command = command;
    }

    public void handleCommandLine() {
        CommandContext context = new CommandContext(this.line);
        this.executeCommand(context);
    }

    public void handleSimpleLine() {
        if (this.line.hasOption("help")) {
            GravitinoCommandLine.displayHelp(this.options);
        } else {
            CommandContext context = new CommandContext(this.line);
            new SimpleCommandHandler(this, this.line, context).handle();
        }
    }

    public static void displayHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(CMD, options);
    }

    private void executeCommand(CommandContext context) {
        if ("help".equals(this.command)) {
            this.handleHelpCommand();
        } else if (this.line.hasOption("owner")) {
            new OwnerCommandHandler(this, this.line, this.command, context, this.entity).handle();
        } else if (this.entity.equals("column")) {
            new ColumnCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("table")) {
            new TableCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("schema")) {
            new SchemaCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("catalog")) {
            new CatalogCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("metalake")) {
            new MetalakeCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("topic")) {
            new TopicCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("fileset")) {
            new FilesetCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("user")) {
            new UserCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("group")) {
            new GroupCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("tag")) {
            new TagCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("role")) {
            new RoleCommandHandler(this, this.line, this.command, context).handle();
        } else if (this.entity.equals("model")) {
            new ModelCommandHandler(this, this.line, this.command, context).handle();
        }
    }

    private void handleHelpCommand() {
        String helpFile = this.entity.toLowerCase() + "_help.txt";
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(helpFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String helpLine;
            StringBuilder helpMessage = new StringBuilder();
            while ((helpLine = reader.readLine()) != null) {
                helpMessage.append(helpLine).append(System.lineSeparator());
            }
            System.out.print(helpMessage.toString());
        }
        catch (IOException e) {
            System.err.println("Failed to load help message: " + e.getMessage());
            Main.exit(-1);
        }
    }
}

