/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Optional;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class OwnerDetails
extends Command {
    protected final String metalake;
    protected final String entity;
    protected final MetadataObject.Type entityType;

    public OwnerDetails(CommandContext context, String metalake, String entity, String entityType) {
        super(context);
        this.metalake = metalake;
        this.entity = entity;
        this.entityType = entityType.equals("metalake") ? MetadataObject.Type.METALAKE : (entityType.equals("catalog") ? MetadataObject.Type.CATALOG : (entityType.equals("schema") ? MetadataObject.Type.SCHEMA : (entityType.equals("table") ? MetadataObject.Type.TABLE : (entityType.equals("column") ? MetadataObject.Type.COLUMN : null))));
    }

    @Override
    public void handle() {
        if (this.entityType == null) {
            this.exitWithError("Unknown entity.");
        }
        Optional<Object> owner = Optional.empty();
        MetadataObject metadata = MetadataObjects.parse(this.entity, this.entityType);
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            owner = client.getOwner(metadata);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchMetadataObjectException err) {
            this.exitWithError("Unknown entity.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (owner.isPresent()) {
            this.printResults(((Owner)owner.get()).name());
        } else {
            this.printInformation("No owner");
        }
    }

    @Override
    public Command validate() {
        if (this.entityType == null) {
            this.exitWithError("Unknown entity.");
        }
        return this;
    }
}

