/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.cli.commands.MetadataCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;

public class RevokeAllPrivileges
extends MetadataCommand {
    protected final String metalake;
    protected final String role;
    protected final FullName entity;

    public RevokeAllPrivileges(CommandContext context, String metalake, String role, FullName entity) {
        super(context);
        this.metalake = metalake;
        this.role = role;
        this.entity = entity;
    }

    @Override
    public void handle() {
        HashMap<String, Set<Privilege>> revokedPrivileges = Maps.newHashMap();
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            List<SecurableObject> matchedObjects = this.getMatchedObjects(client);
            for (SecurableObject securableObject : matchedObjects) {
                String objectFullName = securableObject.fullName();
                HashSet<Privilege> privileges = new HashSet<Privilege>(securableObject.privileges());
                MetadataObject metadataObject = this.constructMetadataObject(this.entity, client);
                client.revokePrivilegesFromRole(this.role, metadataObject, privileges);
                revokedPrivileges.put(objectFullName, privileges);
            }
        }
        catch (NoSuchMetalakeException e) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchRoleException e) {
            this.exitWithError("Unknown role.");
        }
        catch (Exception e) {
            this.exitWithError(e.getMessage());
        }
        if (revokedPrivileges.isEmpty()) {
            this.printInformation("No privileges revoked.");
        } else {
            this.outputRevokedPrivileges(revokedPrivileges);
        }
    }

    private List<SecurableObject> getMatchedObjects(GravitinoClient client) {
        Role gRole = client.getRole(this.role);
        return gRole.securableObjects().stream().filter(s2 -> s2.fullName().equals(this.entity.getName())).collect(Collectors.toList());
    }

    private void outputRevokedPrivileges(Map<String, Set<Privilege>> revokedPrivileges) {
        ArrayList<CallSite> revokedInfoList = Lists.newArrayList();
        for (Map.Entry<String, Set<Privilege>> entry : revokedPrivileges.entrySet()) {
            List revokedPrivilegesList = entry.getValue().stream().map(Privilege::simpleString).collect(Collectors.toList());
            revokedInfoList.add((CallSite)((Object)(entry.getKey() + ": " + COMMA_JOINER.join(revokedPrivilegesList))));
        }
        this.printInformation("Revoked privileges:");
        for (String string : revokedInfoList) {
            this.printResults(string);
        }
    }

    @Override
    public Command validate() {
        if (!this.entity.hasName().booleanValue()) {
            this.exitWithError("Missing --name option.");
        }
        return super.validate();
    }
}

