/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.SupportsCatalogs;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.client.AuthDataProvider;
import org.apache.gravitino.client.GravitinoClientBase;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.IllegalPrivilegeException;
import org.apache.gravitino.exceptions.IllegalRoleException;
import org.apache.gravitino.exceptions.InUseException;
import org.apache.gravitino.exceptions.JobTemplateAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchJobException;
import org.apache.gravitino.exceptions.NoSuchJobTemplateException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.exceptions.PolicyAlreadyExistsException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.exceptions.TagAlreadyExistsException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;
import org.apache.gravitino.job.JobHandle;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.JobTemplateChange;
import org.apache.gravitino.job.SupportsJobs;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.PolicyChange;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.policy.PolicyOperations;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagChange;
import org.apache.gravitino.tag.TagOperations;

public class GravitinoClient
extends GravitinoClientBase
implements SupportsCatalogs,
TagOperations,
SupportsJobs,
PolicyOperations {
    private final GravitinoMetalake metalake;

    private GravitinoClient(String uri, String metalakeName, AuthDataProvider authDataProvider, boolean checkVersion, Map<String, String> headers, Map<String, String> properties) {
        super(uri, authDataProvider, checkVersion, headers, properties);
        this.metalake = this.loadMetalake(metalakeName);
    }

    private GravitinoMetalake getMetalake() {
        return this.metalake;
    }

    @Override
    public String[] listCatalogs() throws NoSuchMetalakeException {
        return this.getMetalake().listCatalogs();
    }

    @Override
    public Catalog[] listCatalogsInfo() throws NoSuchMetalakeException {
        return this.getMetalake().listCatalogsInfo();
    }

    @Override
    public Catalog loadCatalog(String catalogName) throws NoSuchCatalogException {
        return this.getMetalake().loadCatalog(catalogName);
    }

    @Override
    public Catalog createCatalog(String catalogName, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws NoSuchMetalakeException, CatalogAlreadyExistsException {
        return this.getMetalake().createCatalog(catalogName, type, provider, comment, properties);
    }

    @Override
    public Catalog alterCatalog(String catalogName, CatalogChange ... changes) throws NoSuchCatalogException, IllegalArgumentException {
        return this.getMetalake().alterCatalog(catalogName, changes);
    }

    @Override
    public boolean dropCatalog(String catalogName, boolean force) throws NonEmptyEntityException, CatalogInUseException {
        return this.getMetalake().dropCatalog(catalogName, force);
    }

    @Override
    public void enableCatalog(String catalogName) throws NoSuchCatalogException {
        this.getMetalake().enableCatalog(catalogName);
    }

    @Override
    public void disableCatalog(String catalogName) throws NoSuchCatalogException {
        this.getMetalake().disableCatalog(catalogName);
    }

    public User addUser(String user) throws UserAlreadyExistsException, NoSuchMetalakeException {
        return this.getMetalake().addUser(user);
    }

    public boolean removeUser(String user) throws NoSuchMetalakeException {
        return this.getMetalake().removeUser(user);
    }

    public User getUser(String user) throws NoSuchUserException, NoSuchMetalakeException {
        return this.getMetalake().getUser(user);
    }

    public User[] listUsers() {
        return this.getMetalake().listUsers();
    }

    public String[] listUserNames() {
        return this.getMetalake().listUserNames();
    }

    public Group addGroup(String group) throws GroupAlreadyExistsException, NoSuchMetalakeException {
        return this.getMetalake().addGroup(group);
    }

    public boolean removeGroup(String group) throws NoSuchMetalakeException {
        return this.getMetalake().removeGroup(group);
    }

    public Group getGroup(String group) throws NoSuchGroupException, NoSuchMetalakeException {
        return this.getMetalake().getGroup(group);
    }

    public Group[] listGroups() throws NoSuchMetalakeException {
        return this.getMetalake().listGroups();
    }

    public String[] listGroupNames() throws NoSuchMetalakeException {
        return this.getMetalake().listGroupNames();
    }

    public Role getRole(String role) throws NoSuchRoleException, NoSuchMetalakeException {
        return this.getMetalake().getRole(role);
    }

    public boolean deleteRole(String role) throws NoSuchMetalakeException {
        return this.getMetalake().deleteRole(role);
    }

    public Role createRole(String role, Map<String, String> properties, List<SecurableObject> securableObjects) throws RoleAlreadyExistsException, NoSuchMetalakeException, IllegalMetadataObjectException {
        return this.getMetalake().createRole(role, properties, securableObjects);
    }

    public User grantRolesToUser(List<String> roles, String user) throws NoSuchUserException, IllegalRoleException, NoSuchMetalakeException {
        return this.getMetalake().grantRolesToUser(roles, user);
    }

    public Group grantRolesToGroup(List<String> roles, String group) throws NoSuchGroupException, IllegalRoleException, NoSuchMetalakeException {
        return this.getMetalake().grantRolesToGroup(roles, group);
    }

    public User revokeRolesFromUser(List<String> roles, String user) throws NoSuchUserException, IllegalRoleException, NoSuchMetalakeException {
        return this.getMetalake().revokeRolesFromUser(roles, user);
    }

    public Group revokeRolesFromGroup(List<String> roles, String group) throws NoSuchGroupException, IllegalRoleException, NoSuchMetalakeException {
        return this.getMetalake().revokeRolesFromGroup(roles, group);
    }

    public Optional<Owner> getOwner(MetadataObject object) throws NoSuchMetadataObjectException {
        return this.getMetalake().getOwner(object);
    }

    public void setOwner(MetadataObject object, String ownerName, Owner.Type ownerType) throws NotFoundException {
        this.getMetalake().setOwner(object, ownerName, ownerType);
    }

    public String[] listRoleNames() throws NoSuchMetalakeException {
        return this.getMetalake().listRoleNames();
    }

    @Deprecated
    public Role grantPrivilegesToRole(String role, MetadataObject object, List<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        return this.getMetalake().grantPrivilegesToRole(role, object, privileges);
    }

    public Role grantPrivilegesToRole(String role, MetadataObject object, Set<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        return this.getMetalake().grantPrivilegesToRole(role, object, privileges);
    }

    @Deprecated
    public Role revokePrivilegesFromRole(String role, MetadataObject object, List<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        return this.getMetalake().revokePrivilegesFromRole(role, object, Sets.newHashSet(privileges));
    }

    public Role revokePrivilegesFromRole(String role, MetadataObject object, Set<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        return this.getMetalake().revokePrivilegesFromRole(role, object, privileges);
    }

    public static ClientBuilder builder(String uri) {
        return new ClientBuilder(uri);
    }

    @Override
    public void testConnection(String catalogName, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        this.getMetalake().testConnection(catalogName, type, provider, comment, properties);
    }

    @Override
    public String[] listTags() throws NoSuchMetalakeException {
        return this.getMetalake().listTags();
    }

    @Override
    public Tag[] listTagsInfo() throws NoSuchMetalakeException {
        return this.getMetalake().listTagsInfo();
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        return this.getMetalake().getTag(name);
    }

    @Override
    public Tag createTag(String name, String comment, Map<String, String> properties) throws TagAlreadyExistsException {
        return this.getMetalake().createTag(name, comment, properties);
    }

    @Override
    public Tag alterTag(String name, TagChange ... changes) throws NoSuchTagException, IllegalArgumentException {
        return this.getMetalake().alterTag(name, changes);
    }

    @Override
    public boolean deleteTag(String name) {
        return this.getMetalake().deleteTag(name);
    }

    @Override
    public List<JobTemplate> listJobTemplates() {
        return this.getMetalake().listJobTemplates();
    }

    @Override
    public void registerJobTemplate(JobTemplate jobTemplate) throws JobTemplateAlreadyExistsException {
        this.getMetalake().registerJobTemplate(jobTemplate);
    }

    @Override
    public JobTemplate getJobTemplate(String jobTemplateName) throws NoSuchJobTemplateException {
        return this.getMetalake().getJobTemplate(jobTemplateName);
    }

    @Override
    public boolean deleteJobTemplate(String jobTemplateName) throws InUseException {
        return this.getMetalake().deleteJobTemplate(jobTemplateName);
    }

    @Override
    public JobTemplate alterJobTemplate(String jobTemplateName, JobTemplateChange ... changes) throws NoSuchJobTemplateException, IllegalArgumentException {
        return this.getMetalake().alterJobTemplate(jobTemplateName, changes);
    }

    @Override
    public List<JobHandle> listJobs(String jobTemplateName) throws NoSuchJobTemplateException {
        return this.getMetalake().listJobs(jobTemplateName);
    }

    @Override
    public List<JobHandle> listJobs() {
        return this.getMetalake().listJobs();
    }

    @Override
    public JobHandle runJob(String jobTemplateName, Map<String, String> jobConf) throws NoSuchJobTemplateException {
        return this.getMetalake().runJob(jobTemplateName, jobConf);
    }

    @Override
    public JobHandle getJob(String jobId) throws NoSuchJobException {
        return this.getMetalake().getJob(jobId);
    }

    @Override
    public JobHandle cancelJob(String jobId) throws NoSuchJobException {
        return this.getMetalake().cancelJob(jobId);
    }

    @Override
    public String[] listPolicies() throws NoSuchMetalakeException {
        return this.getMetalake().listPolicies();
    }

    @Override
    public Policy[] listPolicyInfos() throws NoSuchMetalakeException {
        return this.getMetalake().listPolicyInfos();
    }

    @Override
    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.getMetalake().getPolicy(name);
    }

    @Override
    public Policy createPolicy(String name, String type, String comment, boolean enabled, PolicyContent content) throws PolicyAlreadyExistsException {
        return this.getMetalake().createPolicy(name, type, comment, enabled, content);
    }

    @Override
    public void enablePolicy(String name) throws NoSuchPolicyException {
        this.getMetalake().enablePolicy(name);
    }

    @Override
    public void disablePolicy(String name) throws NoSuchPolicyException {
        this.getMetalake().disablePolicy(name);
    }

    @Override
    public Policy alterPolicy(String name, PolicyChange ... changes) throws NoSuchPolicyException, IllegalArgumentException {
        return this.getMetalake().alterPolicy(name, changes);
    }

    @Override
    public boolean deletePolicy(String name) {
        return this.getMetalake().deletePolicy(name);
    }

    public static class ClientBuilder
    extends GravitinoClientBase.Builder<GravitinoClient> {
        protected String metalakeName;

        protected ClientBuilder(String uri) {
            super(uri);
        }

        public ClientBuilder withMetalake(String metalakeName) {
            this.metalakeName = metalakeName;
            return this;
        }

        @Override
        public GravitinoClient build() {
            Preconditions.checkArgument(this.uri != null && !this.uri.isEmpty(), "The argument 'uri' must be a valid URI");
            Preconditions.checkArgument(this.metalakeName != null && !this.metalakeName.isEmpty(), "The argument 'metalakeName' must be a valid name");
            return new GravitinoClient(this.uri, this.metalakeName, this.authDataProvider, this.checkVersion, this.headers, this.properties);
        }
    }
}

