/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.dto.AuditDTO;

public class CatalogDTO
implements Catalog {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private Catalog.Type type;
    @JsonProperty(value="provider")
    private String provider;
    @Nullable
    @JsonProperty(value="comment")
    private String comment;
    @Nullable
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    protected CatalogDTO() {
    }

    protected CatalogDTO(String name, Catalog.Type type, String provider, String comment, Map<String, String> properties, AuditDTO audit) {
        this.name = name;
        this.type = type;
        this.provider = provider;
        this.comment = comment;
        this.properties = properties;
        this.audit = audit;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Catalog.Type type() {
        if (this.type == null) {
            return Catalog.Type.UNSUPPORTED;
        }
        return this.type;
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public Audit auditInfo() {
        return this.audit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogDTO)) {
            return false;
        }
        CatalogDTO other = (CatalogDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Catalog.Type this$type = this.type;
        Catalog.Type other$type = other.type;
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$provider = this.provider;
        String other$provider = other.provider;
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        AuditDTO this$audit = this.audit;
        AuditDTO other$audit = other.audit;
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CatalogDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Catalog.Type $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $provider = this.provider;
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        AuditDTO $audit = this.audit;
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public String toString() {
        return "CatalogDTO(name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", provider=" + this.provider + ", comment=" + this.comment + ", properties=" + String.valueOf(this.properties) + ", audit=" + String.valueOf(this.audit) + ")";
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected Catalog.Type type;
        protected String provider;
        protected String comment;
        protected Map<String, String> properties;
        protected AuditDTO audit;

        protected Builder() {
        }

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withType(Catalog.Type type) {
            this.type = type;
            return (S)this;
        }

        public S withProvider(String provider) {
            this.provider = provider;
            return (S)this;
        }

        public S withComment(String comment) {
            this.comment = comment;
            return (S)this;
        }

        public S withProperties(Map<String, String> properties) {
            this.properties = properties;
            return (S)this;
        }

        public S withAudit(AuditDTO audit) {
            this.audit = audit;
            return (S)this;
        }

        public CatalogDTO build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name cannot be null or empty");
            Preconditions.checkArgument(this.type != null, "type cannot be null");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.provider), "provider cannot be null or empty");
            Preconditions.checkArgument(this.audit != null, "audit cannot be null");
            return new CatalogDTO(this.name, this.type, this.provider, this.comment, this.properties, this.audit);
        }
    }
}

